/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.apple2e.SoftSwitches;
import jace.core.Computer;
import jace.core.Device;
import jace.core.PagedMemory;
import jace.core.RAMEvent;
import jace.core.RAMListener;

public abstract class Card
extends Device {
    private PagedMemory cxRom = new PagedMemory(256, PagedMemory.Type.cardFirmware);
    private PagedMemory c8Rom = new PagedMemory(2048, PagedMemory.Type.cardFirmware);
    private int slot;
    private RAMListener ioListener;
    private RAMListener firmwareListener;
    private RAMListener c8firmwareListener;

    @Override
    public String getShortName() {
        return "s" + this.getSlot();
    }

    @Override
    public String getName() {
        return this.getDeviceName() + " (slot " + this.slot + ")";
    }

    public abstract void reset();

    @Override
    public void attach() {
        this.ioListener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(Card.this.slot * 16 + 49280);
                this.setScopeEnd(Card.this.slot * 16 + 49295);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                int address = e.getAddress() & 0xF;
                Card.this.handleIOAccess(address, e.getType(), e.getNewValue(), e);
            }
        };
        this.firmwareListener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(Card.this.slot * 256 + 49152);
                this.setScopeEnd(Card.this.slot * 256 + 49407);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                Computer.getComputer().getMemory().setActiveCard(Card.this.slot);
                if (SoftSwitches.CXROM.getState()) {
                    return;
                }
                Card.this.handleFirmwareAccess(e.getAddress() & 0xFF, e.getType(), e.getNewValue(), e);
            }
        };
        this.c8firmwareListener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(Card.this.slot * 256 + 51200);
                this.setScopeEnd(Card.this.slot * 256 + 53247);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                if (SoftSwitches.CXROM.getState() || Computer.getComputer().getMemory().getActiveSlot() != Card.this.getSlot() || SoftSwitches.INTC8ROM.getState()) {
                    return;
                }
                Card.this.handleC8FirmwareAccess(e.getAddress() - 51200, e.getType(), e.getNewValue(), e);
            }
        };
        Computer.getComputer().getMemory().addListener(this.ioListener);
        Computer.getComputer().getMemory().addListener(this.firmwareListener);
        Computer.getComputer().getMemory().addListener(this.c8firmwareListener);
    }

    @Override
    public void detach() {
        this.suspend();
        Computer.getComputer().getMemory().removeListener(this.ioListener);
        Computer.getComputer().getMemory().removeListener(this.firmwareListener);
        Computer.getComputer().getMemory().removeListener(this.c8firmwareListener);
    }

    protected abstract void handleIOAccess(int var1, RAMEvent.TYPE var2, int var3, RAMEvent var4);

    protected abstract void handleFirmwareAccess(int var1, RAMEvent.TYPE var2, int var3, RAMEvent var4);

    protected abstract void handleC8FirmwareAccess(int var1, RAMEvent.TYPE var2, int var3, RAMEvent var4);

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public PagedMemory getCxRom() {
        return this.cxRom;
    }

    public PagedMemory getC8Rom() {
        return this.c8Rom;
    }

    @Override
    public void reconfigure() {
        boolean restart = this.suspend();
        this.detach();
        if (restart) {
            this.resume();
        }
        this.attach();
    }

    public void notifyVBLStateChanged(boolean state) {
    }

    public boolean suspendWithCPU() {
        return false;
    }
}

