/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.Reconfigurable;

public abstract class Device
implements Reconfigurable {
    private int waitCycles = 0;
    private boolean run = true;
    public boolean isPaused = false;

    public void addWaitCycles(int wait) {
        this.waitCycles += wait;
    }

    public void setWaitCycles(int wait) {
        this.waitCycles = wait;
    }

    public void doTick() {
        if (!this.run) {
            this.isPaused = true;
            return;
        }
        if (this.waitCycles > 0) {
            --this.waitCycles;
            return;
        }
        this.tick();
    }

    public boolean isRunning() {
        return this.run;
    }

    public synchronized void setRun(boolean run) {
        this.isPaused = false;
        this.run = run;
    }

    protected abstract String getDeviceName();

    @Override
    public String getName() {
        return this.getDeviceName();
    }

    public abstract void tick();

    public boolean suspend() {
        if (this.isRunning()) {
            this.setRun(false);
            return true;
        }
        return false;
    }

    public void resume() {
        this.setRun(true);
    }

    public abstract void attach();

    public abstract void detach();
}

