/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.apple2e.SoftSwitches;
import jace.apple2e.Speaker;
import jace.config.ConfigurableField;
import jace.core.CPU;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Device;
import jace.core.SoundMixer;
import jace.core.TimedDevice;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Motherboard
extends TimedDevice {
    static final Computer computer = Computer.getComputer();
    static final CPU cpu = computer.getCpu();
    static Motherboard instance;
    public static final Set<Device> miscDevices;
    @ConfigurableField(name="Enable Speaker", shortName="speaker", defaultValue="true")
    public static boolean enableSpeaker;
    public static Speaker speaker;
    public static SoundMixer mixer;
    @ConfigurableField(category="advanced", name="CPU per clock", defaultValue="1", description="Number of CPU cycles per clock cycle (normal = 1)")
    public static int cpuPerClock;
    public int clockCounter = 1;
    public Card[] cards;
    public static long SPEED;
    static HashSet<Object> accelorationRequestors;
    Map<Card, Boolean> resume = new HashMap<Card, Boolean>();

    static void vblankEnd() {
        SoftSwitches.VBL.getSwitch().setState(true);
        computer.notifyVBLStateChanged(true);
    }

    static void vblankStart() {
        SoftSwitches.VBL.getSwitch().setState(false);
        computer.notifyVBLStateChanged(false);
    }

    public Motherboard() {
        instance = this;
    }

    @Override
    protected String getDeviceName() {
        return "Motherboard";
    }

    @Override
    public String getShortName() {
        return "mb";
    }

    @Override
    public void tick() {
        try {
            --this.clockCounter;
            cpu.doTick();
            if (this.clockCounter > 0) {
                return;
            }
            this.clockCounter = cpuPerClock;
            Computer.getComputer().getVideo().doTick();
            for (int i = 0; i < 7; ++i) {
                if (this.cards[i] == null) continue;
                this.cards[i].doTick();
            }
            for (Device m : miscDevices) {
                if (m == null || !m.isRunning()) continue;
                m.doTick();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public long defaultCyclesPerSecond() {
        return SPEED;
    }

    @Override
    public synchronized void reconfigure() {
        boolean startAgain = this.pause();
        accelorationRequestors.clear();
        super.reconfigure();
        Card[] cards2 = computer.getMemory().getAllCards();
        miscDevices.add(mixer);
        mixer.reconfigure();
        if (enableSpeaker) {
            try {
                if (speaker == null) {
                    speaker = new Speaker();
                } else {
                    speaker.attach();
                }
                if (Motherboard.mixer.lineAvailable) {
                    miscDevices.add(speaker);
                }
            }
            catch (Throwable t) {
                System.out.println("Unable to initalize sound -- deactivating speaker out");
                speaker.detach();
                miscDevices.remove(speaker);
            }
        } else if (speaker != null) {
            speaker.detach();
            miscDevices.remove(speaker);
        }
        if (startAgain && Computer.getComputer().getMemory() != null) {
            this.resume();
        }
    }

    public static void requestSpeed(Object requester) {
        accelorationRequestors.add(requester);
        if (instance != null) {
            instance.enableTempMaxSpeed();
        }
    }

    public static void cancelSpeedRequest(Object requester) {
        accelorationRequestors.remove(requester);
        if (instance != null && accelorationRequestors.isEmpty()) {
            instance.disableTempMaxSpeed();
        }
    }

    @Override
    public void attach() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean suspend() {
        Map<Card, Boolean> map = this.resume;
        synchronized (map) {
            this.resume.clear();
            for (Card c : this.cards) {
                if (c == null || !c.suspendWithCPU() || !c.isRunning()) continue;
                this.resume.put(c, c.suspend());
            }
        }
        return super.suspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        this.cards = computer.getMemory().getAllCards();
        super.resume();
        Map<Card, Boolean> map = this.resume;
        synchronized (map) {
            for (Card c : this.cards) {
                if (!Boolean.TRUE.equals(this.resume.get(c))) continue;
                c.resume();
            }
        }
    }

    @Override
    public void detach() {
        for (Device d : miscDevices) {
            d.suspend();
        }
        miscDevices.clear();
    }

    static {
        miscDevices = new HashSet<Device>();
        enableSpeaker = true;
        mixer = new SoundMixer();
        cpuPerClock = 1;
        SPEED = 1020484L;
        accelorationRequestors = new HashSet();
    }
}

