/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.core.RAMEvent;

public abstract class RAMListener {
    private RAMEvent.TYPE type;
    private RAMEvent.SCOPE scope;
    private RAMEvent.VALUE value;
    private int scopeStart;
    private int scopeEnd;
    private int valueStart;
    private int valueEnd;
    private int valueAmount;

    public RAMListener(RAMEvent.TYPE t, RAMEvent.SCOPE s, RAMEvent.VALUE v) {
        this.setType(t);
        this.setScope(s);
        this.setValue(v);
        this.doConfig();
    }

    public RAMEvent.TYPE getType() {
        return this.type;
    }

    public void setType(RAMEvent.TYPE type) {
        this.type = type;
    }

    public RAMEvent.SCOPE getScope() {
        return this.scope;
    }

    public void setScope(RAMEvent.SCOPE scope) {
        this.scope = scope;
    }

    public RAMEvent.VALUE getValue() {
        return this.value;
    }

    public void setValue(RAMEvent.VALUE value) {
        this.value = value;
    }

    public int getScopeStart() {
        return this.scopeStart;
    }

    public void setScopeStart(int scopeStart) {
        this.scopeStart = scopeStart;
    }

    public int getScopeEnd() {
        return this.scopeEnd;
    }

    public void setScopeEnd(int scopeEnd) {
        this.scopeEnd = scopeEnd;
    }

    public int getValueStart() {
        return this.valueStart;
    }

    public void setValueStart(int valueStart) {
        this.valueStart = valueStart;
    }

    public int getValueEnd() {
        return this.valueEnd;
    }

    public void setValueEnd(int valueEnd) {
        this.valueEnd = valueEnd;
    }

    public int getValueAmount() {
        return this.valueAmount;
    }

    public void setValueAmount(int valueAmount) {
        this.valueAmount = valueAmount;
    }

    public boolean isRelevant(RAMEvent e) {
        if (this.type != RAMEvent.TYPE.ANY && e.getType() != RAMEvent.TYPE.ANY && this.type != e.getType()) {
            if (this.type == RAMEvent.TYPE.READ) {
                if (!e.getType().isRead()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.scope != RAMEvent.SCOPE.ANY) {
            if (this.scope == RAMEvent.SCOPE.ADDRESS && e.getAddress() != this.scopeStart) {
                return false;
            }
            if (this.scope == RAMEvent.SCOPE.RANGE && (e.getAddress() < this.scopeStart || e.getAddress() > this.scopeEnd)) {
                return false;
            }
        }
        if (this.value != RAMEvent.VALUE.ANY) {
            if (this.value == RAMEvent.VALUE.CHANGE_BY && e.getNewValue() - e.getOldValue() != this.valueAmount) {
                return false;
            }
            if (this.value == RAMEvent.VALUE.EQUALS && e.getNewValue() != this.valueAmount) {
                return false;
            }
            if (this.value == RAMEvent.VALUE.NOT_EQUALS && e.getNewValue() == this.valueAmount) {
                return false;
            }
            if (this.value == RAMEvent.VALUE.RANGE && (e.getNewValue() < this.valueStart || e.getNewValue() > this.valueEnd)) {
                return false;
            }
        }
        return true;
    }

    public void handleEvent(RAMEvent e) {
        if (this.isRelevant(e)) {
            this.doEvent(e);
        }
    }

    protected abstract void doConfig();

    protected abstract void doEvent(RAMEvent var1);
}

