/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Utility {
    private static Map<Class, Collection<Class>> classCache = new HashMap<Class, Collection<Class>>();
    static Map<Class, Map<String, Object>> enumCache = new HashMap<Class, Map<String, Object>>();

    private static Set<Class> findClasses(String pckgname, Class clazz) {
        URL url;
        HashSet<Class> output = new HashSet<Class>();
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((url = Utility.class.getResource(name = name.replace('.', '/'))) == null || url.getFile().contains("jre/lib")) {
            return output;
        }
        if (url.getProtocol().equalsIgnoreCase("jar")) {
            return Utility.findClassesInJar(url, clazz);
        }
        File directory = new File(url.getFile());
        if (directory.exists()) {
            for (String filename : directory.list()) {
                char firstLetter = filename.charAt(0);
                if (firstLetter < 'A' || firstLetter > 'Z' && firstLetter < 'a' || firstLetter > 'z' || !filename.endsWith(".class")) continue;
                String classname = filename.substring(0, filename.length() - 6);
                try {
                    String className = pckgname + "." + classname;
                    Class<?> c = Class.forName(className);
                    if (!clazz.isAssignableFrom(c)) continue;
                    output.add(c);
                }
                catch (ClassNotFoundException cnfex) {
                    System.err.println(cnfex);
                }
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Class> findClassesInJar(URL jarLocation, Class clazz) {
        HashSet<Class> output = new HashSet<Class>();
        JarFile jarFile = null;
        try {
            JarURLConnection conn = (JarURLConnection)jarLocation.openConnection();
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            String last = "";
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.getName().equals(last)) {
                    HashSet<Class> hashSet = output;
                    return hashSet;
                }
                last = jarEntry.getName();
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName();
                className = className.substring(0, className.length() - 6);
                if ((className = className.replaceAll("/", "\\.")).startsWith("com.sun") || className.startsWith("java") || className.startsWith("javax") || className.startsWith("com.oracle")) continue;
                try {
                    Class<?> c = Class.forName(className);
                    if (!clazz.isAssignableFrom(c)) continue;
                    output.add(c);
                }
                catch (ClassNotFoundException cnfex) {
                    System.err.println(cnfex);
                }
                catch (Throwable cnfex) {}
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return output;
    }

    public static List<Class> findAllSubclasses(Class clazz) {
        if (classCache.containsKey(clazz)) {
            return (List)classCache.get(clazz);
        }
        TreeMap<String, Class> allClasses = new TreeMap<String, Class>();
        for (Package p : Package.getPackages()) {
            if (p.getName().startsWith("java") || p.getName().startsWith("com.sun") || p.getName().startsWith("com.oracle")) continue;
            for (Class c : Utility.findClasses(p.getName(), clazz)) {
                if (Modifier.isAbstract(c.getModifiers())) continue;
                allClasses.put(c.getSimpleName(), c);
            }
        }
        ArrayList<Class> values = new ArrayList<Class>(allClasses.values());
        classCache.put(clazz, values);
        return values;
    }

    public static int levenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null || s.length() == 0 || t.length() == 0) {
            return -1;
        }
        s = s.toLowerCase().replaceAll("[^a-zA-Z0-9\\s]", "");
        t = t.toLowerCase().replaceAll("[^a-zA-Z0-9\\s]", "");
        int m = s.length();
        int n = t.length();
        int[][] dist = new int[m + 1][n + 1];
        for (i = 1; i <= m; ++i) {
            dist[i][0] = i;
        }
        for (i = 1; i <= n; ++i) {
            dist[0][i] = i;
        }
        for (int j = 1; j <= n; ++j) {
            for (int i2 = 1; i2 <= m; ++i2) {
                if (s.charAt(i2 - 1) == t.charAt(j - 1)) {
                    dist[i2][j] = dist[i2 - 1][j - 1];
                    continue;
                }
                int del = dist[i2 - 1][j] + 1;
                int insert = dist[i2][j - 1] + 1;
                int sub = dist[i2 - 1][j - 1] + 1;
                dist[i2][j] = Math.min(Math.min(del, insert), sub);
            }
        }
        return Math.max(m, n) - dist[m][n];
    }

    public static double rankMatch(String c1, String c2, int width) {
        double score = 0.0;
        String s1 = c1.toLowerCase();
        String s2 = c2.toLowerCase();
        for (int i = 0; i < s1.length() + 1 - width; ++i) {
            String m = s1.substring(i, i + width);
            int j = 0;
            while ((j = s2.indexOf(m, j)) > -1) {
                score += (double)width;
                ++j;
            }
        }
        double l1 = s1.length();
        double l2 = s2.length();
        double adjustment = Math.min(l1, l2) / Math.max(l1, l2) + 0.1;
        return score * adjustment * adjustment;
    }

    public static String join(Collection c, String d) {
        String result = "";
        boolean isFirst = true;
        for (Object o : c) {
            result = result + (isFirst ? "" : d) + o.toString();
            isFirst = false;
        }
        return result;
    }

    public static ImageIcon loadIcon(String filename) {
        URL imageUrl = Utility.class.getClassLoader().getResource("jace/data/" + filename);
        ImageIcon i = new ImageIcon(imageUrl);
        return i;
    }

    public static String findBestMatch(String match, Collection<String> search) {
        if (search == null || search.isEmpty()) {
            return null;
        }
        RankingComparator r = new RankingComparator(match);
        ArrayList<String> candidates = new ArrayList<String>(search);
        Collections.sort(candidates, r);
        double score = Utility.levenshteinDistance(match, (String)candidates.get(0));
        if (score > 1.0) {
            return (String)candidates.get(0);
        }
        return null;
    }

    public static void printStackTrace() {
        System.out.println("CURRENT STACK TRACE:");
        for (StackTraceElement s : Thread.currentThread().getStackTrace()) {
            System.out.println(s.getClassName() + "." + s.getMethodName() + " (line " + s.getLineNumber() + ") " + (s.isNativeMethod() ? "NATIVE" : ""));
        }
        System.out.println("END OF STACK TRACE");
    }

    public static int parseHexInt(Object s) {
        if (s == null) {
            return -1;
        }
        if (s instanceof Integer) {
            return (Integer)s;
        }
        String val = String.valueOf(s).trim();
        int base = 10;
        if (val.startsWith("$")) {
            base = 16;
            val = val.contains(" ") ? val.substring(1, val.indexOf(32)) : val.substring(1);
        } else if (val.startsWith("0x")) {
            base = 16;
            val = val.contains(" ") ? val.substring(2, val.indexOf(32)) : val.substring(2);
        }
        try {
            return Integer.parseInt(val, base);
        }
        catch (NumberFormatException ex) {
            Utility.gripe("This isn't a valid number: " + val + ".  If you put a $ in front of that then I'll know you meant it to be a hex number.");
            throw ex;
        }
    }

    public static void gripe(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, message, "Error", 0);
            }
        });
    }

    public static Object findChild(Object object, String fieldName) {
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                if (!key.toString().equalsIgnoreCase(fieldName)) continue;
                return map.get(key);
            }
            return null;
        }
        try {
            Field f = object.getClass().getField(fieldName);
            return f.get(object);
        }
        catch (Throwable ex) {
            for (Method m : object.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase("get" + fieldName) || m.getParameterTypes().length != 0) continue;
                try {
                    return m.invoke(object, new Object[0]);
                }
                catch (Throwable ex1) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static Object setChild(Object object, String fieldName, String value, boolean hex) {
        Field f;
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry key : map.entrySet()) {
                if (!key.toString().equalsIgnoreCase(fieldName)) continue;
                map.put(key, value);
                return null;
            }
            return null;
        }
        try {
            f = object.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            System.out.println("Object type " + object.getClass().getName() + " has no field named " + fieldName);
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (SecurityException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        Object useValue = Utility.deserializeString(value, f.getType(), hex);
        try {
            f.set(object, useValue);
            return useValue;
        }
        catch (Throwable ex) {
            for (Method m : object.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase("set" + fieldName) || m.getParameterTypes().length != 0) continue;
                try {
                    m.invoke(object, useValue);
                }
                catch (Throwable ex1) {
                    // empty catch block
                }
            }
            return useValue;
        }
    }

    public static Object findClosestEnumConstant(String value, Class type) {
        String key;
        Map<String, Object> enumConstants = enumCache.get(type);
        if (enumConstants == null) {
            T[] constants = type.getEnumConstants();
            enumConstants = new HashMap<String, Object>();
            for (Object o : constants) {
                enumConstants.put(o.toString(), o);
            }
            enumCache.put(type, enumConstants);
        }
        if ((key = Utility.findBestMatch(value, enumConstants.keySet())) == null) {
            return null;
        }
        return enumConstants.get(key);
    }

    public static Object deserializeString(String value, Class type, boolean hex) {
        int radix;
        int n = radix = hex ? 16 : 10;
        if (type.equals(Integer.TYPE) || type == Integer.class) {
            value = value.replaceAll(hex ? "[^0-9\\-A-Fa-f]" : "[^0-9\\-]", "");
            try {
                return Integer.parseInt(value, radix);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (type.equals(Short.TYPE) || type == Short.class) {
            value = value.replaceAll(hex ? "[^0-9\\-\\.A-Fa-f]" : "[^0-9\\-\\.]", "");
            try {
                return Short.parseShort(value, radix);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (type.equals(Long.TYPE) || type == Long.class) {
            value = value.replaceAll(hex ? "[^0-9\\-\\.A-Fa-f]" : "[^0-9\\-\\.]", "");
            try {
                return Long.parseLong(value, radix);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (type.equals(Byte.TYPE) || type == Byte.class) {
            try {
                value = value.replaceAll(hex ? "[^0-9\\-A-Fa-f]" : "[^0-9\\-]", "");
                return Byte.parseByte(value, radix);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (type.equals(Boolean.TYPE) || type == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (type == File.class) {
            return new File(String.valueOf(value));
        }
        if (type.isEnum()) {
            value = value.replaceAll("[\\.\\s\\-]", "");
            return Utility.findClosestEnumConstant(value, type);
        }
        return null;
    }

    public static Object getProperty(Object object, String path) {
        String[] paths = path.split("\\.");
        for (int i = 0; i < paths.length; ++i) {
            if ((object = Utility.findChild(object, paths[i])) != null) continue;
            return null;
        }
        return object;
    }

    public static Object setProperty(Object object, String path, String value, boolean hex) {
        String[] paths = path.split("\\.");
        for (int i = 0; i < paths.length - 1; ++i) {
            if ((object = Utility.findChild(object, paths[i])) != null) continue;
            return null;
        }
        return Utility.setChild(object, paths[paths.length - 1], value, hex);
    }

    public static class RankingComparator
    implements Comparator<String> {
        String match;

        public RankingComparator(String match) {
            this.match = match + " ";
        }

        @Override
        public int compare(String o1, String o2) {
            double s1 = Utility.levenshteinDistance(this.match, o1);
            double s2 = Utility.levenshteinDistance(this.match, o2);
            if (s2 == s1) {
                s1 = Utility.rankMatch(o1, this.match, 3) + Utility.rankMatch(o1, this.match, 2);
                s2 = Utility.rankMatch(o2, this.match, 3) + Utility.rankMatch(o2, this.match, 2);
                if (s2 == s1) {
                    return o1.compareTo(o2);
                }
                return (int)Math.signum(s2 - s1);
            }
            return (int)(s2 - s1);
        }
    }
}

