/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.Emulator;
import jace.apple2e.MOS65C02;
import jace.apple2e.RAM128k;
import jace.config.ConfigurableField;
import jace.config.Name;
import jace.core.Card;
import jace.core.Computer;
import jace.core.PagedMemory;
import jace.core.RAMEvent;
import jace.core.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;

@Name(value="Apple Mouse")
public class CardAppleMouse
extends Card
implements MouseListener {
    private int mode;
    private boolean active;
    private boolean interruptOnMove;
    private boolean interruptOnPress;
    private boolean interruptOnVBL;
    private boolean button0press;
    private boolean button1press;
    private boolean button0pressLast;
    private boolean button1pressLast;
    private boolean isInterrupt;
    private boolean isVBL;
    private int statusByte;
    private Point lastMouseLocation;
    Point clampMin = new Point(0, 1023);
    Point clampMax = new Point(0, 1023);
    @ConfigurableField(name="Update frequency", shortName="updateFreq", category="Mouse", description="# of CPU cycles between updates; affects polling and interrupt-based routines")
    public static int CYCLES_PER_UPDATE = 17008;
    ImageIcon mouseActive = Utility.loadIcon("input-mouse.png");
    private int delay = CYCLES_PER_UPDATE;

    @Override
    public String getDeviceName() {
        return "Apple Mouse";
    }

    @Override
    public void reset() {
        this.mode = 0;
        this.deactivateMouse();
    }

    @Override
    protected void handleFirmwareAccess(int offset, RAMEvent.TYPE type, int value, RAMEvent e) {
        if (type == RAMEvent.TYPE.EXECUTE) {
            switch (offset - 128) {
                case 0: {
                    this.setMouse();
                    break;
                }
                case 1: {
                    this.serveMouse();
                    break;
                }
                case 2: {
                    this.readMouse();
                    break;
                }
                case 3: {
                    this.clearMouse();
                    break;
                }
                case 4: {
                    this.posMouse();
                    break;
                }
                case 5: {
                    this.clampMouse();
                    break;
                }
                case 6: {
                    this.homeMouse();
                    break;
                }
                case 7: {
                    this.initMouse();
                }
            }
            e.setNewValue(96);
        } else if (type.isRead()) {
            switch (offset) {
                case 5: {
                    e.setNewValue(56);
                    break;
                }
                case 7: {
                    e.setNewValue(24);
                    break;
                }
                case 11: {
                    e.setNewValue(1);
                    break;
                }
                case 12: {
                    e.setNewValue(32);
                    break;
                }
                case 251: {
                    e.setNewValue(214);
                    break;
                }
                case 8: {
                    e.setNewValue(1);
                }
                case 17: {
                    e.setNewValue(0);
                    break;
                }
                case 18: {
                    e.setNewValue(128);
                    break;
                }
                case 19: {
                    e.setNewValue(129);
                    break;
                }
                case 20: {
                    e.setNewValue(130);
                    break;
                }
                case 21: {
                    e.setNewValue(131);
                    break;
                }
                case 22: {
                    e.setNewValue(132);
                    break;
                }
                case 23: {
                    e.setNewValue(133);
                    break;
                }
                case 24: {
                    e.setNewValue(134);
                    break;
                }
                case 25: {
                    e.setNewValue(135);
                    break;
                }
                default: {
                    e.setNewValue(105);
                }
            }
        }
    }

    private MOS65C02 getCPU() {
        return (MOS65C02)Computer.getComputer().getCpu();
    }

    private void setMouse() {
        this.mode = this.getCPU().A & 0xFF;
        if (this.mode > 15) {
            this.getCPU().C = 1;
            return;
        }
        this.getCPU().C = 0;
        if ((this.mode & 1) == 0) {
            this.deactivateMouse();
            return;
        }
        this.interruptOnMove = (this.mode & 2) != 0;
        this.interruptOnPress = (this.mode & 4) != 0;
        this.interruptOnVBL = (this.mode & 8) != 0;
        this.activateMouse();
    }

    private void serveMouse() {
        this.updateMouseState();
        this.getCPU().C = this.isInterrupt ? 0 : 1;
    }

    private void readMouse() {
        this.updateMouseState();
        this.isInterrupt = false;
        this.isVBL = false;
        this.getCPU().C = 0;
    }

    private void posMouse() {
        this.getCPU().C = 0;
    }

    private void clampMouse() {
        RAM128k memory = (RAM128k)Computer.getComputer().memory;
        byte clampMinLo = memory.getMainMemory().readByte(1144);
        byte clampMaxLo = memory.getMainMemory().readByte(1272);
        byte clampMinHi = memory.getMainMemory().readByte(1400);
        byte clampMaxHi = memory.getMainMemory().readByte(1528);
        int min = clampMinLo & 0xFF | clampMinHi << 8 & 0xFF00;
        int max = clampMaxLo & 0xFF | clampMaxHi << 8 & 0xFF00;
        if (this.getCPU().A == 0) {
            this.setClampWindowX(min, max);
        } else if (this.getCPU().A == 1) {
            this.setClampWindowY(min, max);
        }
    }

    private void initMouse() {
        this.mouseActive.setDescription("Active");
        Emulator.getFrame().addIndicator(this, this.mouseActive, 2000);
        this.setClampWindowX(0, 1023);
        this.setClampWindowY(0, 1023);
        this.clearMouse();
    }

    private void clearMouse() {
        this.isVBL = false;
        this.isInterrupt = false;
        this.button0press = false;
        this.button1press = false;
        this.button0pressLast = false;
        this.button1pressLast = false;
        this.homeMouse();
    }

    private void homeMouse() {
        this.lastMouseLocation = new Point(0, 0);
        this.updateMouseState();
        this.getCPU().C = 0;
    }

    private void activateMouse() {
        this.active = true;
        Component drawingArea = Emulator.getScreen();
        if (drawingArea != null) {
            drawingArea.addMouseListener(this);
        }
    }

    private void deactivateMouse() {
        this.active = false;
        this.mode = 0;
        this.interruptOnMove = false;
        this.interruptOnPress = false;
        this.interruptOnVBL = false;
        Component drawingArea = Emulator.getScreen();
        if (drawingArea != null) {
            drawingArea.removeMouseListener(this);
        }
    }

    @Override
    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    @Override
    public void tick() {
        Point currentMouseLocation;
        if (!this.active) {
            return;
        }
        --this.delay;
        if (this.delay > 0) {
            return;
        }
        this.delay = CYCLES_PER_UPDATE;
        if (!this.interruptOnMove && !this.interruptOnPress) {
            return;
        }
        if (this.interruptOnPress && (this.button0press != this.button0pressLast || this.button1press != this.button1pressLast)) {
            this.isInterrupt = true;
            this.getCPU().generateInterrupt();
            return;
        }
        if (this.interruptOnMove && !(currentMouseLocation = MouseInfo.getPointerInfo().getLocation()).equals(this.lastMouseLocation)) {
            this.isInterrupt = true;
            this.getCPU().generateInterrupt();
        }
    }

    @Override
    public void notifyVBLStateChanged(boolean state) {
        if (!state && this.interruptOnVBL && this.active) {
            this.isVBL = true;
            this.isInterrupt = true;
            this.getCPU().generateInterrupt();
        }
    }

    private void updateMouseState() {
        boolean mouseMoved;
        Component drawingArea = Emulator.getScreen();
        if (drawingArea == null) {
            return;
        }
        Point currentMouseLocation = MouseInfo.getPointerInfo().getLocation();
        Point topLeft = drawingArea.getLocationOnScreen();
        Dimension d = drawingArea.getSize();
        double width = this.clampMax.x - this.clampMin.x;
        double x = currentMouseLocation.getX() - (double)topLeft.x;
        x /= (double)d.width;
        x *= width;
        if ((x += (double)this.clampMin.x) < (double)this.clampMin.x) {
            x = this.clampMin.x;
        }
        if (x > (double)this.clampMax.x) {
            x = this.clampMax.x;
        }
        double height = this.clampMax.y - this.clampMin.y;
        double y = currentMouseLocation.getY() - (double)topLeft.y;
        y /= (double)d.height;
        y *= height;
        if ((y += (double)this.clampMin.y) < (double)this.clampMin.y) {
            y = this.clampMin.y;
        }
        if (y > (double)this.clampMax.y) {
            y = this.clampMax.y;
        }
        PagedMemory m = ((RAM128k)Computer.getComputer().getMemory()).getMainMemory();
        int s = this.getSlot();
        m.writeByte(1144 + s, (byte)((int)x & 0xFF));
        m.writeByte(1272 + s, (byte)((int)y & 0xFF));
        m.writeByte(1400 + s, (byte)(((int)x & 0xFF00) >> 8));
        m.writeByte(1528 + s, (byte)(((int)y & 0xFF00) >> 8));
        int status = 0;
        boolean bl = mouseMoved = !currentMouseLocation.equals(this.lastMouseLocation);
        if (this.button1pressLast) {
            status |= 1;
        }
        if (this.interruptOnMove && mouseMoved) {
            status |= 2;
        }
        if (this.interruptOnPress && (this.button0press != this.button0pressLast || this.button1press != this.button1pressLast)) {
            status |= 4;
        }
        if (this.isVBL) {
            status |= 8;
        }
        if (this.button1press) {
            status |= 0x10;
        }
        if (mouseMoved) {
            status |= 0x20;
        }
        if (this.button0pressLast) {
            status |= 0x40;
        }
        if (this.button0press) {
            status |= 0x80;
        }
        m.writeByte(1912 + s, (byte)status);
        m.writeByte(2040 + s, (byte)this.mode);
        this.lastMouseLocation = currentMouseLocation;
        this.button0pressLast = this.button0press;
        this.button1pressLast = this.button1press;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int button = me.getButton();
        if (button == 1 || button == 2) {
            this.button0press = true;
        }
        if (button == 2 || button == 3) {
            this.button1press = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int button = me.getButton();
        if (button == 1 || button == 2) {
            this.button0press = false;
        }
        if (button == 2 || button == 3) {
            this.button1press = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    private void setClampWindowX(int min, int max) {
        if (max == Short.MAX_VALUE) {
            max = 560;
        }
        this.clampMin.x = min;
        this.clampMax.x = max;
    }

    private void setClampWindowY(int min, int max) {
        if (max == Short.MAX_VALUE) {
            max = 192;
        }
        this.clampMin.y = min;
        this.clampMax.y = max;
    }

    @Override
    protected void handleC8FirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }
}

