/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.apple2e.SoftSwitches;
import jace.apple2e.softswitch.MemorySoftSwitch;
import jace.config.ConfigurableField;
import jace.core.Computer;
import jace.core.Device;
import jace.core.KeyHandler;
import jace.core.Keyboard;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Joystick
extends Device {
    @ConfigurableField(name="Enabled", shortName="enabled", description="If unchecked, then there is no joystick support.")
    public boolean enabled;
    @ConfigurableField(name="Center Mouse", description="Moves mouse back to the center of the screen, can get annoying.")
    public boolean centerMouse;
    @ConfigurableField(name="Use keyboard", shortName="useKeys", description="Arrow keys will control joystick instead of the mouse.")
    public boolean useKeyboard;
    @ConfigurableField(name="Hog keypresses", shortName="hog", description="Key presses will not be sent to emulator.")
    public boolean hogKeyboard;
    public int port;
    private int x = 0;
    private int y = 0;
    private int joyX = 0;
    private int joyY = 0;
    MemorySoftSwitch xSwitch;
    MemorySoftSwitch ySwitch;
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Point lastMouseLocation;
    Robot robot;
    Point centerPoint;
    public boolean leftPressed = false;
    public boolean rightPressed = false;
    public boolean upPressed = false;
    public boolean downPressed = false;
    RAMListener listener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

        @Override
        protected void doConfig() {
            this.setScopeStart(49264);
            this.setScopeEnd(49279);
        }

        @Override
        protected void doEvent(RAMEvent e) {
            Joystick.this.setRun(true);
            Joystick.this.readJoystick();
            Joystick.this.xSwitch.setState(true);
            Joystick.this.x = 10 + Joystick.this.joyX * 11;
            Joystick.this.ySwitch.setState(true);
            Joystick.this.y = 10 + Joystick.this.joyY * 11;
        }
    };

    public Joystick(int port) {
        this.centerPoint = new Point(this.screenSize.width / 2, this.screenSize.height / 2);
        this.port = port;
        if (port == 0) {
            this.xSwitch = (MemorySoftSwitch)SoftSwitches.PDL0.getSwitch();
            this.ySwitch = (MemorySoftSwitch)SoftSwitches.PDL1.getSwitch();
        } else {
            this.xSwitch = (MemorySoftSwitch)SoftSwitches.PDL2.getSwitch();
            this.ySwitch = (MemorySoftSwitch)SoftSwitches.PDL3.getSwitch();
        }
        this.lastMouseLocation = MouseInfo.getPointerInfo().getLocation();
        try {
            this.robot = new Robot();
        }
        catch (AWTException ex) {
            Logger.getLogger(Joystick.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readJoystick() {
        if (this.useKeyboard) {
            int n = this.leftPressed ? (this.rightPressed ? 128 : 0) : (this.joyX = this.rightPressed ? 255 : 128);
            this.joyY = this.upPressed ? (this.downPressed ? 128 : 0) : (this.downPressed ? 255 : 128);
        } else {
            Point l = MouseInfo.getPointerInfo().getLocation();
            this.joyX = l.x < this.lastMouseLocation.x ? 0 : (l.x > this.lastMouseLocation.x ? 255 : 128);
            this.joyY = l.y < this.lastMouseLocation.y ? 0 : (l.y > this.lastMouseLocation.y ? 255 : 128);
            if (this.centerMouse) {
                this.lastMouseLocation = this.centerPoint;
                this.robot.mouseMove(this.centerPoint.x, this.centerPoint.y);
            } else {
                if (l.x <= 20) {
                    this.robot.mouseMove(20, l.y);
                    l = MouseInfo.getPointerInfo().getLocation();
                }
                if ((double)(l.x + 21) == this.screenSize.getWidth()) {
                    this.robot.mouseMove((int)(this.screenSize.getWidth() - 20.0), l.y);
                    l = MouseInfo.getPointerInfo().getLocation();
                }
                if (l.y <= 20) {
                    this.robot.mouseMove(l.x, 20);
                    l = MouseInfo.getPointerInfo().getLocation();
                }
                if ((double)(l.y + 21) == this.screenSize.getHeight()) {
                    this.robot.mouseMove(l.x, (int)(this.screenSize.getHeight() - 20.0));
                    l = MouseInfo.getPointerInfo().getLocation();
                }
                this.lastMouseLocation = l;
            }
        }
    }

    @Override
    protected String getDeviceName() {
        return "Joystick (port " + this.port + ")";
    }

    @Override
    public String getShortName() {
        return "joy" + this.port;
    }

    @Override
    public void tick() {
        boolean finished = true;
        if (this.x > 0) {
            if (--this.x == 0) {
                this.xSwitch.setState(false);
            } else {
                finished = false;
            }
        }
        if (this.y > 0) {
            if (--this.y == 0) {
                this.ySwitch.setState(false);
            } else {
                finished = false;
            }
        }
        if (finished) {
            this.setRun(false);
        }
    }

    @Override
    public void attach() {
        this.registerListeners();
    }

    @Override
    public void detach() {
        this.removeListeners();
    }

    @Override
    public void reconfigure() {
        this.x = 0;
        this.y = 0;
        if (this.enabled) {
            this.registerListeners();
        } else {
            this.removeListeners();
        }
    }

    private void registerListeners() {
        Computer.getComputer().getMemory().addListener(this.listener);
        if (this.useKeyboard) {
            System.out.println("Registering key handlers");
            Keyboard.registerKeyHandler(new KeyHandler(37, new int[]{-1}){

                @Override
                public boolean handleKeyUp(KeyEvent e) {
                    Joystick.this.leftPressed = false;
                    return Joystick.this.hogKeyboard;
                }

                @Override
                public boolean handleKeyDown(KeyEvent e) {
                    Joystick.this.leftPressed = true;
                    return Joystick.this.hogKeyboard;
                }
            }, this);
            Keyboard.registerKeyHandler(new KeyHandler(39, new int[]{-1}){

                @Override
                public boolean handleKeyUp(KeyEvent e) {
                    Joystick.this.rightPressed = false;
                    return Joystick.this.hogKeyboard;
                }

                @Override
                public boolean handleKeyDown(KeyEvent e) {
                    Joystick.this.rightPressed = true;
                    return Joystick.this.hogKeyboard;
                }
            }, this);
            Keyboard.registerKeyHandler(new KeyHandler(38, new int[]{-1}){

                @Override
                public boolean handleKeyUp(KeyEvent e) {
                    Joystick.this.upPressed = false;
                    return Joystick.this.hogKeyboard;
                }

                @Override
                public boolean handleKeyDown(KeyEvent e) {
                    Joystick.this.upPressed = true;
                    return Joystick.this.hogKeyboard;
                }
            }, this);
            Keyboard.registerKeyHandler(new KeyHandler(40, new int[]{-1}){

                @Override
                public boolean handleKeyUp(KeyEvent e) {
                    Joystick.this.downPressed = false;
                    return Joystick.this.hogKeyboard;
                }

                @Override
                public boolean handleKeyDown(KeyEvent e) {
                    Joystick.this.downPressed = true;
                    return Joystick.this.hogKeyboard;
                }
            }, this);
        }
    }

    private void removeListeners() {
        Computer.getComputer().getMemory().removeListener(this.listener);
        Keyboard.unregisterAllHandlers(this);
    }
}

