/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.config.Name;
import jace.core.Card;
import jace.core.Computer;
import jace.core.RAMEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;

@Name(value="Passport Midi Interface", description="MIDI sound card")
public class PassportMidiInterface
extends Card {
    public static final int TIMER_CONTROL_1 = 0;
    public static final int TIMER_CONTROL_2 = 1;
    public static final int TIMER1_MSB = 2;
    public static final int TIMER1_LSB = 3;
    public static final int TIMER2_MSB = 4;
    public static final int TIMER2_LSB = 5;
    public static final int TIMER3_MSB = 6;
    public static final int TIMER3_LSB = 7;
    public static final int ACIA_CONTROL = 8;
    public static final int ACIA_SEND = 9;
    public static final int ACIA_STATUS = 8;
    public static final int ACIA_RECV = 9;
    public static final int DRUM_SYNC_SET = 14;
    public static final int DRUM_SYNC_CLEAR = 15;
    public static final int PTM_START_TIMERS = 0;
    public static final int PTM_STOP_TIMERS = 1;
    public static final int PTM_RESET = 67;
    public static final int PTM_SELECT_REG_1 = 1;
    public static final int PTM_SELECT_REG_3 = 0;
    public static final int TIMER_3_PRESCALED = 1;
    public static final int TIMER_3_NOT_PRESCALED = 0;
    public static final int PTM_CLOCK_SOURCE = 2;
    public static final int PTM_LATCH_IS_16_BIT = 4;
    public static final int PTM_CONTINUOUS = 0;
    public static final int PTM_SINGLE_SHOT = 32;
    public static final int PTM_FREQ_COMP = 8;
    public static final int PTM_PULSE_COMP = 24;
    public static final int PTM_IRQ_ENABLED = 64;
    public static final int PTM_OUTPUT_ENABLED = 128;
    public static final int ACIA_RESET = 19;
    public static final int ACIA_MASK_INTERRUPTS = 17;
    public static final int ACIA_OFF = 21;
    public static final int ACIA_INT_ON_SEND = 49;
    public static final int ACIA_INT_ON_RECV = 145;
    public static final int ACIA_INT_ON_SEND_AND_RECV = 177;
    public static final int ACIA_COUNTER_1 = 0;
    public static final int ACIA_COUNTER_16 = 1;
    public static final int ACIA_COUNTER_64 = 2;
    public static final int ACIA_MASTER_RESET = 3;
    public static final int ACIA_ODD_PARITY = 4;
    public static final int ACIA_STOP_BITS_1 = 8;
    public static final int ACIA_WORD_LENGTH_8 = 16;
    public static final int ACIA_RECV_INTERRUPT = 128;
    private boolean ptmTimer3Selected = false;
    private boolean ptmTimersActive = false;
    private PTMTimer[] ptmTimer = new PTMTimer[]{new PTMTimer(), new PTMTimer(), new PTMTimer()};
    private boolean ptmStatusReadSinceIRQ = false;
    private boolean aciaInterruptOnSend = false;
    private boolean aciaInterruptOnReceive = false;
    private boolean receivedACIAByte = false;
    private boolean transmitACIAEmpty = true;
    private boolean receiverACIAOverrun = false;
    private boolean irqRequestedACIA = false;
    private Synthesizer synth;
    ShortMessage currentMessage;
    int currentMessageStatus;
    int currentMessageData1;
    int currentMessageData2;
    int messageSize = 255;
    int currentMessageReceived = 0;

    @Override
    protected void handleC8FirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    @Override
    public void reset() {
        this.suspend();
    }

    @Override
    public boolean suspend() {
        this.suspendACIA();
        return super.suspend();
    }

    @Override
    protected void handleFirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    @Override
    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        block0 : switch (type) {
            case READ_DATA: {
                int returnValue = 0;
                switch (register) {
                    case 8: {
                        returnValue = this.getACIAStatus();
                        break;
                    }
                    case 9: {
                        returnValue = this.getACIARecieve();
                        break;
                    }
                    case 0: {
                        returnValue = this.getPTMStatus();
                        break;
                    }
                    case 1: {
                        returnValue = this.getPTMStatus();
                        break;
                    }
                    case 3: {
                        returnValue = (int)(this.ptmTimer[0].value & 0xFFL);
                        if (!this.ptmStatusReadSinceIRQ) break;
                        this.ptmTimer[0].irqRequested = false;
                        break;
                    }
                    case 2: {
                        returnValue = (int)(this.ptmTimer[0].value >> 8) & 0xFF;
                        if (!this.ptmStatusReadSinceIRQ) break;
                        this.ptmTimer[0].irqRequested = false;
                        break;
                    }
                    case 5: {
                        returnValue = (int)(this.ptmTimer[1].value & 0xFFL);
                        if (!this.ptmStatusReadSinceIRQ) break;
                        this.ptmTimer[1].irqRequested = false;
                        break;
                    }
                    case 4: {
                        returnValue = (int)(this.ptmTimer[1].value >> 8) & 0xFF;
                        if (!this.ptmStatusReadSinceIRQ) break;
                        this.ptmTimer[1].irqRequested = false;
                        break;
                    }
                    case 7: {
                        returnValue = (int)(this.ptmTimer[2].value & 0xFFL);
                        if (!this.ptmStatusReadSinceIRQ) break;
                        this.ptmTimer[2].irqRequested = false;
                        break;
                    }
                    case 6: {
                        returnValue = (int)(this.ptmTimer[2].value >> 8) & 0xFF;
                        if (!this.ptmStatusReadSinceIRQ) break;
                        this.ptmTimer[2].irqRequested = false;
                        break;
                    }
                    default: {
                        System.out.println("Passport midi read unrecognized, port " + register);
                    }
                }
                e.setNewValue(returnValue);
                break;
            }
            case WRITE: {
                int v = e.getNewValue() & 0xFF;
                switch (register) {
                    case 8: {
                        this.processACIAControl(v);
                        break block0;
                    }
                    case 9: {
                        this.processACIASend(v);
                        break block0;
                    }
                    case 0: {
                        if (this.ptmTimer3Selected) {
                            this.ptmTimer[2].prescaledTimer = (v & 1) != 0;
                            this.processPTMConfiguration(this.ptmTimer[2], v);
                            break block0;
                        }
                        if ((v & 1) == 0) {
                            this.startPTM();
                        } else {
                            this.stopPTM();
                        }
                        this.processPTMConfiguration(this.ptmTimer[0], v);
                        break block0;
                    }
                    case 1: {
                        this.ptmTimer3Selected = (v & 1) == 0;
                        this.processPTMConfiguration(this.ptmTimer[1], v);
                        break block0;
                    }
                    case 3: {
                        this.ptmTimer[0].duration = this.ptmTimer[0].duration & 0xFF00L | (long)v;
                        break block0;
                    }
                    case 2: {
                        this.ptmTimer[0].duration = this.ptmTimer[0].duration & 0xFFL | (long)(v << 8);
                        break block0;
                    }
                    case 5: {
                        this.ptmTimer[1].duration = this.ptmTimer[1].duration & 0xFF00L | (long)v;
                        break block0;
                    }
                    case 4: {
                        this.ptmTimer[1].duration = this.ptmTimer[1].duration & 0xFFL | (long)(v << 8);
                        break block0;
                    }
                    case 7: {
                        this.ptmTimer[2].duration = this.ptmTimer[2].duration & 0xFF00L | (long)v;
                        break block0;
                    }
                    case 6: {
                        this.ptmTimer[2].duration = this.ptmTimer[2].duration & 0xFF00L | (long)(v << 8);
                        break block0;
                    }
                }
                System.out.println("Passport midi write unrecognized, port " + register);
            }
        }
    }

    @Override
    public void tick() {
        if (this.ptmTimersActive) {
            PTMTimer[] arr$ = this.ptmTimer;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PTMTimer t;
                PTMTimer pTMTimer = t = arr$[i$];
                Long l = pTMTimer.value;
                Long l2 = pTMTimer.value = Long.valueOf(pTMTimer.value - 1L);
                if (t.value >= 0L) continue;
                if (t.irqEnabled) {
                    t.irqRequested = true;
                    Computer.getComputer().getCpu().generateInterrupt();
                    this.ptmStatusReadSinceIRQ = false;
                }
                if (t.mode != TIMER_MODE.continuous && t.mode != TIMER_MODE.freqComparison) continue;
                t.value = t.duration;
            }
        }
    }

    @Override
    public String getDeviceName() {
        return "Passport MIDI Controller";
    }

    private void processPTMConfiguration(PTMTimer timer, int val) {
        timer.enableClock = (val & 2) != 0;
        timer.dual8BitMode = (val & 4) != 0;
        switch (val & 0x38) {
            case 0: {
                timer.mode = TIMER_MODE.continuous;
                break;
            }
            case 24: {
                timer.mode = TIMER_MODE.pulseComparison;
                break;
            }
            case 8: {
                timer.mode = TIMER_MODE.freqComparison;
                break;
            }
            case 32: {
                timer.mode = TIMER_MODE.singleShot;
                break;
            }
            default: {
                timer.mode = TIMER_MODE.continuous;
            }
        }
        timer.irqEnabled = (val & 0x40) != 0;
        timer.counterOutputEnable = (val & 0x80) != 0;
    }

    private void stopPTM() {
        this.ptmTimersActive = false;
    }

    private void startPTM() {
        this.ptmTimersActive = true;
        this.ptmTimer[0].irqRequested = false;
        this.ptmTimer[1].irqRequested = false;
        this.ptmTimer[2].irqRequested = false;
        this.ptmTimer[0].value = this.ptmTimer[0].duration;
        this.ptmTimer[1].value = this.ptmTimer[1].duration;
        this.ptmTimer[2].value = this.ptmTimer[2].duration;
    }

    private int getPTMStatus() {
        int status = 0;
        for (int i = 0; i < 3; ++i) {
            PTMTimer t = this.ptmTimer[i];
            if (!t.irqRequested || !t.irqEnabled) continue;
            this.ptmStatusReadSinceIRQ = true;
            status |= 1 << i;
            status |= 0x80;
        }
        return status;
    }

    private int getACIAStatus() {
        int status = 0;
        if (this.receivedACIAByte) {
            status |= 1;
        }
        if (this.transmitACIAEmpty) {
            status |= 2;
        }
        if (this.receiverACIAOverrun) {
            status |= 0x20;
        }
        if (this.irqRequestedACIA) {
            status |= 0x80;
        }
        return status;
    }

    private int getACIARecieve() {
        return 0;
    }

    private void processACIAControl(int value) {
        if ((value & 3) == 3) {
            this.resume();
        }
    }

    private void processACIASend(int value) {
        if (!this.isRunning()) {
            return;
        }
        boolean sendMessage = false;
        if (this.currentMessage != null) {
            if ((value & 0x80) > 0) {
                if (this.currentMessage != null) {
                    sendMessage = true;
                }
            } else {
                ++this.currentMessageReceived;
                if (this.currentMessageReceived >= this.messageSize) {
                    sendMessage = true;
                }
                if (this.currentMessageReceived == 1) {
                    this.currentMessageData1 = value;
                } else {
                    this.currentMessageData2 = value;
                    sendMessage = true;
                }
            }
        }
        if (sendMessage) {
            if (this.synth != null && this.synth.isOpen()) {
                try {
                    this.currentMessage.setMessage(this.currentMessageStatus, this.currentMessageData1, this.currentMessageData2);
                    this.synth.getReceiver().send(this.currentMessage, -1L);
                }
                catch (InvalidMidiDataException ex) {
                    Logger.getLogger(PassportMidiInterface.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (MidiUnavailableException ex) {
                    Logger.getLogger(PassportMidiInterface.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.currentMessage = null;
        }
        if ((value & 0x80) > 0) {
            this.currentMessage = new ShortMessage();
            this.currentMessageStatus = value;
            this.currentMessageData1 = 0;
            this.currentMessageData2 = 0;
            try {
                this.currentMessage.setMessage(this.currentMessageStatus, 0, 0);
                this.messageSize = this.currentMessage.getLength();
            }
            catch (InvalidMidiDataException ex) {
                this.messageSize = 0;
            }
            this.currentMessageReceived = 0;
        }
    }

    @Override
    public void resume() {
        if (this.isRunning() && this.synth != null && this.synth.isOpen()) {
            return;
        }
        try {
            MidiDevice.Info[] devices = MidiSystem.getMidiDeviceInfo();
            if (devices.length == 0) {
                System.out.println("No MIDI devices found");
            } else {
                for (MidiDevice.Info dev : devices) {
                    System.out.println("MIDI Device found: " + dev);
                    if (!dev.getName().contains("Java Sound") || !(dev instanceof Synthesizer)) continue;
                    this.synth = (Synthesizer)((Object)dev);
                    break;
                }
            }
            if (this.synth == null) {
                this.synth = MidiSystem.getSynthesizer();
            }
            if (this.synth != null) {
                System.out.println("Selected MIDI device: " + this.synth.getDeviceInfo().getName());
                this.synth.open();
                super.resume();
            }
        }
        catch (MidiUnavailableException ex) {
            System.out.println("Could not open MIDI synthesizer");
            ex.printStackTrace();
            Logger.getLogger(PassportMidiInterface.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void suspendACIA() {
        if (this.synth != null && this.synth.isOpen()) {
            this.synth.close();
            this.synth = null;
        }
    }

    public static class PTMTimer {
        public boolean prescaledTimer = false;
        public boolean enableClock = false;
        public boolean dual8BitMode = false;
        public TIMER_MODE mode = TIMER_MODE.continuous;
        public boolean irqEnabled = false;
        public boolean counterOutputEnable = false;
        public Long duration = 0L;
        public boolean irqRequested = true;
        public Long value = 0L;
    }

    public static enum TIMER_MODE {
        continuous,
        singleShot,
        freqComparison,
        pulseComparison;

    }
}

