/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.apple2e.MOS65C02;
import jace.core.Computer;
import jace.core.RAM;
import jace.hardware.massStorage.CardMassStorage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SmartportDriver {
    public void handleSmartport() {
        int returnCode = this.callSmartport().intValue;
        MOS65C02 cpu = (MOS65C02)Computer.getComputer().getCpu();
        cpu.A = returnCode;
        cpu.C = returnCode == 0 ? 0 : 1;
    }

    private ERROR_CODE callSmartport() {
        int callAddress;
        MOS65C02 cpu = (MOS65C02)Computer.getComputer().getCpu();
        RAM ram = Computer.getComputer().getMemory();
        byte command = ram.readRaw(callAddress = cpu.popWord() + 1);
        boolean extendedCall = command >= 64;
        cpu.setProgramCounter(callAddress + (extendedCall ? 5 : 3));
        int parmAddr = 0;
        if (!extendedCall) {
            parmAddr = ram.readWordRaw(callAddress + 1);
        } else {
            int parmAddrLo = ram.readWordRaw(callAddress + 1);
            int parmAddrHi = ram.readWordRaw(callAddress + 3);
            parmAddr = parmAddrHi << 16 | parmAddrLo;
        }
        System.out.println("Received command " + command + " with address block " + Integer.toHexString(parmAddr));
        byte numParms = ram.readRaw(parmAddr);
        int[] params = new int[16];
        for (int i = 0; i < 16; ++i) {
            int value;
            params[i] = value = 0xFF & ram.readRaw(parmAddr + i);
            System.out.print(Integer.toHexString(value) + " ");
        }
        System.out.println();
        int unitNumber = params[1];
        if (!this.changeUnit(unitNumber)) {
            System.out.println("Invalid unit: " + unitNumber);
            return ERROR_CODE.INVALID_UNIT;
        }
        int dataBuffer = params[2] | params[3] << 8;
        try {
            switch (command) {
                case 0: {
                    return this.returnStatus(dataBuffer, params);
                }
                case 1: {
                    int blockNum = params[4] | params[5] << 8 | params[6] << 16;
                    this.read(blockNum, dataBuffer);
                    return ERROR_CODE.NO_ERROR;
                }
                case 2: {
                    int blockNum = params[4] | params[5] << 8 | params[6] << 16;
                    this.write(blockNum, dataBuffer);
                    return ERROR_CODE.NO_ERROR;
                }
            }
            System.out.println("Unimplemented command " + command);
            return ERROR_CODE.INVALID_COMMAND;
        }
        catch (IOException ex) {
            Logger.getLogger(CardMassStorage.class.getName()).log(Level.SEVERE, null, ex);
            return ERROR_CODE.INVALID_CODE;
        }
    }

    public abstract boolean changeUnit(int var1);

    public abstract void read(int var1, int var2) throws IOException;

    public abstract void write(int var1, int var2) throws IOException;

    public abstract ERROR_CODE returnStatus(int var1, int[] var2);

    public static enum ERROR_CODE {
        NO_ERROR(0),
        INVALID_COMMAND(1),
        BAD_PARAM_COUNT(4),
        INVALID_UNIT(17),
        INVALID_CODE(33),
        BAD_BLOCK_NUMBER(45);

        int intValue;

        private ERROR_CODE(int c) {
            this.intValue = c;
        }
    }
}

