/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.Emulator;
import jace.apple2e.MOS65C02;
import jace.config.ConfigurableField;
import jace.config.Name;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Motherboard;
import jace.core.RAMEvent;
import jace.core.Utility;
import jace.hardware.ProdosDriver;
import jace.hardware.SmartportDriver;
import jace.hardware.massStorage.IDisk;
import jace.hardware.massStorage.LargeDisk;
import jace.hardware.massStorage.ProdosVirtualDisk;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

@Name(value="Mass Storage Device")
public class CardMassStorage
extends Card {
    ImageIcon drive1icon;
    ImageIcon drive2icon;
    static int SLT16 = 43;
    static int DEVICE_DRIVER_OFFSET = 10;
    IDisk disk1;
    IDisk disk2;
    @ConfigurableField(name="Drive 1", shortName="d1")
    public File disk1path = null;
    @ConfigurableField(name="Drive 2", shortName="d2")
    public File disk2path = null;
    byte[] cardSignature = new byte[]{-87, 32, -87, 0, -87, 3, -87, 60, -48, 7, 96, -80, 1, 24, -80, 90};
    Card theCard = this;
    public IDisk currentDisk;
    ProdosDriver driver = new ProdosDriver(){

        @Override
        public boolean changeUnit(int unit) {
            CardMassStorage.this.currentDisk = unit == 0 ? CardMassStorage.this.disk1 : CardMassStorage.this.disk2;
            return CardMassStorage.this.currentDisk != null;
        }

        @Override
        public int getSize() {
            return CardMassStorage.this.currentDisk != null ? CardMassStorage.this.currentDisk.getSize() : 0;
        }

        @Override
        public boolean isWriteProtected() {
            return CardMassStorage.this.currentDisk != null ? CardMassStorage.this.currentDisk.isWriteProtected() : true;
        }

        @Override
        public void mliFormat() throws IOException {
            CardMassStorage.this.currentDisk.mliFormat();
        }

        @Override
        public void mliRead(int block, int bufferAddress) throws IOException {
            CardMassStorage.this.currentDisk.mliRead(block, bufferAddress);
        }

        @Override
        public void mliWrite(int block, int bufferAddress) throws IOException {
            CardMassStorage.this.currentDisk.mliWrite(block, bufferAddress);
        }

        @Override
        public Card getOwner() {
            return CardMassStorage.this.theCard;
        }
    };
    SmartportDriver smartport = new SmartportDriver(){

        @Override
        public boolean changeUnit(int unitNumber) {
            CardMassStorage.this.currentDisk = unitNumber == 1 ? CardMassStorage.this.disk1 : CardMassStorage.this.disk2;
            return CardMassStorage.this.currentDisk != null;
        }

        @Override
        public void read(int blockNum, int buffer) throws IOException {
            CardMassStorage.this.currentDisk.mliRead(blockNum, buffer);
        }

        @Override
        public void write(int blockNum, int buffer) throws IOException {
            CardMassStorage.this.currentDisk.mliWrite(blockNum, buffer);
        }

        @Override
        public SmartportDriver.ERROR_CODE returnStatus(int dataBuffer, int[] params) {
            return SmartportDriver.ERROR_CODE.NO_ERROR;
        }
    };

    public CardMassStorage() {
        this.drive1icon = Utility.loadIcon("drive-harddisk.png");
        this.drive2icon = Utility.loadIcon("drive-harddisk.png");
    }

    @Override
    public void setSlot(int slot) {
        super.setSlot(slot);
        this.drive1icon.setDescription("S" + this.getSlot() + "D1");
        this.drive2icon.setDescription("S" + this.getSlot() + "D2");
    }

    @Override
    public String getDeviceName() {
        return "Mass Storage Device";
    }

    @Override
    public void reconfigure() {
        try {
            this.detach();
            if (this.disk1path == null) {
                if (this.disk1 != null) {
                    this.disk1.eject();
                    this.disk1 = null;
                }
            } else if (this.disk1 == null) {
                this.disk1 = this.readDisk(this.disk1path);
            } else if (!this.disk1.getPhysicalPath().equals(this.disk1path)) {
                this.disk1.eject();
                this.disk1 = this.readDisk(this.disk1path);
            }
            if (this.disk2path == null) {
                if (this.disk2 != null) {
                    this.disk2.eject();
                    this.disk2 = null;
                }
            } else if (this.disk2 == null) {
                this.disk2 = this.readDisk(this.disk2path);
            } else if (!this.disk2.getPhysicalPath().equals(this.disk2path)) {
                this.disk2.eject();
                this.disk2 = this.readDisk(this.disk2path);
            }
            int pc = Computer.getComputer().getCpu().getProgramCounter();
            if (this.disk1 != null && this.getSlot() == 7 && (pc == 50782 || pc == 50785)) {
                this.disk1.boot0(this.getSlot());
                Card[] cards2 = Computer.getComputer().getMemory().getAllCards();
                Motherboard.cancelSpeedRequest(cards2[6]);
            }
            this.attach();
        }
        catch (IOException ex) {
            Logger.getLogger(CardMassStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private IDisk readDisk(File f) {
        if (f.isFile()) {
            return new LargeDisk(f);
        }
        if (f.isDirectory()) {
            try {
                return new ProdosVirtualDisk(f);
            }
            catch (IOException ex) {
                System.out.println("Unable to open virtual disk: " + ex.getMessage());
                Logger.getLogger(CardMassStorage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    protected void handleC8FirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    @Override
    protected void handleFirmwareAccess(int offset, RAMEvent.TYPE type, int value, RAMEvent e) {
        MOS65C02 cpu = (MOS65C02)Computer.getComputer().getCpu();
        if (type.isRead()) {
            if (this.currentDisk == this.disk1) {
                Emulator.getFrame().addIndicator(this, this.drive1icon);
            } else if (this.currentDisk == this.disk2) {
                Emulator.getFrame().addIndicator(this, this.drive2icon);
            }
            if (this.disk1 == null && this.disk2 == null) {
                e.setNewValue(0);
                return;
            }
            if (type == RAMEvent.TYPE.EXECUTE) {
                String error = null;
                if (offset == 0) {
                    e.setNewValue(234);
                    try {
                        if (this.disk1 != null) {
                            this.disk1.boot0(this.getSlot());
                        } else {
                            e.setNewValue(96);
                        }
                        return;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(CardMassStorage.class.getName()).log(Level.SEVERE, null, ex);
                        error = ex.getMessage();
                        cpu.setProgramCounter(57343);
                        int address = 1152;
                        for (char c : error.toCharArray()) {
                            Computer.getComputer().getMemory().write(address++, (byte)(c + 128), false, false);
                        }
                    }
                } else {
                    if (offset == DEVICE_DRIVER_OFFSET) {
                        this.driver.handleMLI();
                    } else if (offset == DEVICE_DRIVER_OFFSET + 3) {
                        this.smartport.handleSmartport();
                    } else {
                        System.out.println("Call to unknown handler " + Integer.toString(e.getAddress(), 16) + "-- returning");
                    }
                    e.setNewValue(96);
                }
            }
            if (offset < 16) {
                e.setNewValue(this.cardSignature[offset]);
            } else {
                switch (offset) {
                    case 252: {
                        e.setNewValue(255);
                        break;
                    }
                    case 253: {
                        e.setNewValue(127);
                        break;
                    }
                    case 254: {
                        e.setNewValue(215);
                        break;
                    }
                    case 255: {
                        e.setNewValue(DEVICE_DRIVER_OFFSET);
                    }
                }
            }
        }
    }

    @Override
    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    @Override
    public void tick() {
    }
}

