/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.hardware.massStorage.ProdosVirtualDisk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DiskNode {
    boolean allocated = false;
    long allocationTime = -1L;
    long lastCheckTime = -1L;
    int baseBlock = -1;
    List<DiskNode> additionalNodes = new ArrayList<DiskNode>();
    ProdosVirtualDisk ownerFilesystem;
    File physicalFile;
    DiskNode parent;
    List<DiskNode> children = new ArrayList<DiskNode>();
    private EntryType type;
    private String name;

    public boolean checkFile() throws IOException {
        this.allocate();
        if (this.physicalFile == null) {
            return false;
        }
        if (this.physicalFile.lastModified() != this.lastCheckTime) {
            this.lastCheckTime = this.physicalFile.lastModified();
            this.refresh();
            return false;
        }
        return true;
    }

    public void allocate() throws IOException {
        if (!this.allocated) {
            this.doAllocate();
            this.allocationTime = System.currentTimeMillis();
            this.allocated = true;
            this.ownerFilesystem.allocateEntry(this);
        }
    }

    public void deallocate() {
        if (this.allocated) {
            this.ownerFilesystem.deallocateEntry(this);
            this.doDeallocate();
            this.allocationTime = -1L;
            this.allocated = false;
            this.additionalNodes.clear();
            for (DiskNode node : this.getChildren()) {
                node.deallocate();
            }
        }
    }

    public void refresh() {
        this.ownerFilesystem.deallocateEntry(this);
        this.doRefresh();
        this.allocationTime = System.currentTimeMillis();
        this.allocated = true;
        this.ownerFilesystem.allocateEntry(this);
    }

    public boolean isAllocated() {
        return this.allocated;
    }

    public long getAllocationTime() {
        return this.allocationTime;
    }

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public int getBaseBlock() {
        return this.baseBlock;
    }

    public void setBaseBlock(int baseBlock) {
        this.baseBlock = baseBlock;
    }

    public ProdosVirtualDisk getOwnerFilesystem() {
        return this.ownerFilesystem;
    }

    public void setOwnerFilesystem(ProdosVirtualDisk ownerFilesystem) throws IOException {
        this.ownerFilesystem = ownerFilesystem;
        if (this.baseBlock == -1) {
            this.setBaseBlock(ownerFilesystem.getNextFreeBlock());
        }
        ownerFilesystem.allocateEntry(this);
    }

    public File getPhysicalFile() {
        return this.physicalFile;
    }

    public void setPhysicalFile(File physicalFile) {
        this.physicalFile = physicalFile;
        this.setName(physicalFile.getName());
    }

    public DiskNode getParent() {
        return this.parent;
    }

    public void setParent(DiskNode parent) {
        this.parent = parent;
    }

    public List<DiskNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<DiskNode> children) {
        this.children = children;
    }

    public void addChild(DiskNode child) {
        this.children.add(child);
    }

    public void removeChild(DiskNode child) {
        this.children.remove(child);
    }

    public EntryType getType() {
        return this.type;
    }

    public void setType(EntryType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.length() > 15) {
            name = name.substring(0, 15);
        }
        this.name = name.toUpperCase();
    }

    public abstract void doDeallocate();

    public abstract void doAllocate() throws IOException;

    public abstract void doRefresh();

    public abstract void readBlock(int var1, byte[] var2) throws IOException;

    public void readBlock(byte[] buffer) throws IOException {
        this.checkFile();
        this.readBlock(0, buffer);
    }

    public static enum EntryType {
        DELETED(0),
        SEEDLING(1),
        SAPLING(2),
        TREE(3),
        SUBDIRECTORY(13),
        SUBDIRECTORY_HEADER(14),
        VOLUME_HEADER(15);

        public int code;

        private EntryType(int c) {
            this.code = c;
        }
    }
}

