/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.mockingboard;

import jace.hardware.mockingboard.TimedGenerator;

public class EnvelopeGenerator
extends TimedGenerator {
    boolean hold = false;
    boolean attk = false;
    boolean alt = false;
    boolean cont = false;
    int direction;
    int amplitude;

    public EnvelopeGenerator(int _clock, int _sampleRate) {
        super(_clock, _sampleRate);
    }

    @Override
    public int stepsPerCycle() {
        return 8;
    }

    @Override
    public void setPeriod(int p) {
        if (p > 0) {
            super.setPeriod(p);
        } else {
            this.clocksPerPeriod = this.stepsPerCycle() / 2;
        }
    }

    public void step() {
        int stateChanges = this.updateCounter();
        for (int i = 0; i < stateChanges; ++i) {
            if (this.amplitude == 0 && this.direction == -1) {
                if (!this.cont) {
                    this.direction = 0;
                } else if (this.hold) {
                    this.direction = 0;
                    if (this.alt) {
                        this.amplitude = 15;
                    }
                } else if (this.alt) {
                    this.direction = 1;
                } else {
                    this.amplitude = 15;
                }
            }
            if (this.amplitude == 15 && this.direction == 1) {
                if (!this.cont) {
                    this.direction = 0;
                    this.amplitude = 0;
                } else if (this.hold) {
                    this.direction = 0;
                    if (this.alt) {
                        this.amplitude = 0;
                    }
                } else if (this.alt) {
                    this.direction = -1;
                } else {
                    this.amplitude = 0;
                }
            }
            this.amplitude += this.direction;
        }
    }

    public void setShape(int shape) {
        this.counter = 0.0;
        this.cont = (shape & 8) != 0;
        this.attk = (shape & 4) != 0;
        this.alt = (shape & 2) != 0;
        boolean bl = this.hold = (shape & 1) != 0;
        if (this.attk) {
            this.amplitude = 0;
            this.direction = 1;
        } else {
            this.amplitude = 15;
            this.direction = -1;
        }
    }

    public int getAmplitude() {
        return this.amplitude;
    }

    @Override
    public void reset() {
        super.reset();
        this.setShape(0);
    }
}

