/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.mockingboard;

import jace.hardware.mockingboard.EnvelopeGenerator;
import jace.hardware.mockingboard.NoiseGenerator;
import jace.hardware.mockingboard.SoundGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class PSG {
    int baseReg;
    List<SoundGenerator> channels;
    EnvelopeGenerator envelopeGenerator;
    NoiseGenerator noiseGenerator;
    int CLOCK;
    int SAMPLE_RATE;
    public int bus;
    int selectedReg;
    String name;
    Map<Reg, Integer> regValues;

    public PSG(int base, int clock, int sample_rate, String name) {
        this.name = name;
        this.baseReg = base;
        this.channels = new ArrayList<SoundGenerator>();
        for (int i = 0; i < 3; ++i) {
            this.channels.add(new SoundGenerator(clock, sample_rate));
        }
        this.envelopeGenerator = new EnvelopeGenerator(clock, sample_rate);
        this.noiseGenerator = new NoiseGenerator(clock, sample_rate);
        this.regValues = Collections.synchronizedMap(new EnumMap(Reg.class));
        this.reset();
    }

    public void setBus(int b) {
        this.bus = b;
    }

    public void setControl(int c) {
        BusControl cmd = BusControl.fromInt(c);
        if (cmd == null) {
            return;
        }
        switch (cmd) {
            case inactive: {
                break;
            }
            case latch: {
                this.selectedReg = this.bus & 0xF;
                break;
            }
            case read: {
                this.bus = this.getReg(Reg.get(this.selectedReg));
                break;
            }
            case write: {
                this.setReg(Reg.get(this.selectedReg), this.bus);
            }
        }
    }

    public int getBaseReg() {
        return this.baseReg;
    }

    public void setRate(int clock, int sample_rate) {
        this.CLOCK = clock;
        this.SAMPLE_RATE = sample_rate;
        for (SoundGenerator c : this.channels) {
            c.setRate(clock, sample_rate);
        }
        this.envelopeGenerator.setRate(clock, sample_rate);
        this.noiseGenerator.setRate(clock, sample_rate);
        this.reset();
    }

    public final void reset() {
        for (Reg r : Reg.values()) {
            this.setReg(r, r == Reg.Enable ? 255 : 0);
        }
        this.envelopeGenerator.reset();
        this.noiseGenerator.reset();
        for (SoundGenerator c : this.channels) {
            c.reset();
        }
    }

    public void setReg(Reg r, int value) {
        if (r != null) {
            this.regValues.put(r, value &= r.max);
            this.writeReg(r, value & 0xFF);
        }
    }

    public int getReg(Reg r) {
        if (r == null) {
            return -1;
        }
        Integer value = this.regValues.get((Object)r);
        if (value == null) {
            return -1;
        }
        return value & 0xFF;
    }

    public void writeReg(Reg r, int value) {
        switch (r) {
            case ACoarse: 
            case AFine: {
                this.channels.get(0).setPeriod(this.getReg(Reg.AFine) + (this.getReg(Reg.ACoarse) << 8));
                break;
            }
            case BCoarse: 
            case BFine: {
                this.channels.get(1).setPeriod(this.getReg(Reg.BFine) + (this.getReg(Reg.BCoarse) << 8));
                break;
            }
            case CCoarse: 
            case CFine: {
                this.channels.get(2).setPeriod(this.getReg(Reg.CFine) + (this.getReg(Reg.CCoarse) << 8));
                break;
            }
            case NoisePeriod: {
                this.noiseGenerator.setPeriod(value);
                this.noiseGenerator.counter = 0.0;
                break;
            }
            case Enable: {
                this.channels.get(0).setActive((value & 1) == 0);
                this.channels.get(0).setNoiseActive((value & 8) == 0);
                this.channels.get(1).setActive((value & 2) == 0);
                this.channels.get(1).setNoiseActive((value & 0x10) == 0);
                this.channels.get(2).setActive((value & 4) == 0);
                this.channels.get(2).setNoiseActive((value & 0x20) == 0);
                break;
            }
            case AVol: {
                this.channels.get(0).setAmplitude(value);
                break;
            }
            case BVol: {
                this.channels.get(1).setAmplitude(value);
                break;
            }
            case CVol: {
                this.channels.get(2).setAmplitude(value);
                break;
            }
            case EnvFine: 
            case EnvCoarse: {
                this.envelopeGenerator.setPeriod(this.getReg(Reg.EnvFine) + 256 * this.getReg(Reg.EnvCoarse));
                break;
            }
            case EnvShape: {
                this.envelopeGenerator.setShape(value);
                break;
            }
        }
    }

    public void update(int[] bufA, boolean clearA, int[] bufB, boolean clearB, int[] bufC, boolean clearC, int length) {
        for (int i = 0; i < length; ++i) {
            this.noiseGenerator.step();
            this.envelopeGenerator.step();
            if (clearA) {
                bufA[i] = this.channels.get(0).step(this.noiseGenerator, this.envelopeGenerator);
            } else {
                int n = i;
                bufA[n] = bufA[n] + this.channels.get(0).step(this.noiseGenerator, this.envelopeGenerator);
            }
            if (clearB) {
                bufB[i] = this.channels.get(1).step(this.noiseGenerator, this.envelopeGenerator);
            } else {
                int n = i;
                bufB[n] = bufB[n] + this.channels.get(1).step(this.noiseGenerator, this.envelopeGenerator);
            }
            if (clearC) {
                bufC[i] = this.channels.get(2).step(this.noiseGenerator, this.envelopeGenerator);
                continue;
            }
            int n = i;
            bufC[n] = bufC[n] + this.channels.get(2).step(this.noiseGenerator, this.envelopeGenerator);
        }
    }

    public static enum BusControl {
        inactive(4),
        read(5),
        write(6),
        latch(7);

        int val;

        private BusControl(int v) {
            this.val = v;
        }

        public static BusControl fromInt(int i) {
            for (BusControl b : BusControl.values()) {
                if (b.val != i) continue;
                return b;
            }
            return null;
        }
    }

    public static enum Reg {
        AFine(0, 255),
        ACoarse(1, 15),
        BFine(2, 255),
        BCoarse(3, 15),
        CFine(4, 255),
        CCoarse(5, 15),
        NoisePeriod(6, 31),
        Enable(7, 255),
        AVol(8, 31),
        BVol(9, 31),
        CVol(10, 31),
        EnvFine(11, 255),
        EnvCoarse(12, 255),
        EnvShape(13, 15),
        PortA(14, 255),
        PortB(15, 255);

        public final int registerNumber;
        public final int max;
        public static Reg[] preferredOrder;

        private Reg(int number, int maxValue) {
            this.registerNumber = number;
            this.max = maxValue;
        }

        static Reg get(int number) {
            for (Reg r : Reg.values()) {
                if (r.registerNumber != number) continue;
                return r;
            }
            return null;
        }

        static {
            preferredOrder = new Reg[]{Enable, EnvShape, EnvCoarse, EnvFine, NoisePeriod, AVol, BVol, CVol, AFine, ACoarse, BFine, BCoarse, CFine, CCoarse};
        }
    }
}

