/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.mockingboard;

import jace.core.Computer;
import jace.core.Device;

public abstract class R6522
extends Device {
    public int oraReg = 0;
    public int iraReg = 0;
    public int orbReg = 0;
    public int irbReg = 0;
    public int dataDirectionA = 0;
    public int dataDirectionB = 0;
    public boolean timer1interruptEnabled = true;
    public boolean timer1IRQ = false;
    public int timer1latch = 0;
    public int timer1counter = 0;
    public boolean timer1freerun = false;
    public boolean timer1running = false;
    public boolean timer2interruptEnabled = true;
    public boolean timer2IRQ = false;
    public int timer2latch = 0;
    public int timer2counter = 0;
    public boolean timer2running = false;

    @Override
    protected String getDeviceName() {
        return "6522 VIA Chip";
    }

    @Override
    public void tick() {
        if (this.timer1running) {
            --this.timer1counter;
            if (this.timer1counter < 0) {
                this.timer1counter = this.timer1latch;
                if (!this.timer1freerun) {
                    this.timer1running = false;
                }
                if (this.timer1interruptEnabled) {
                    this.timer1IRQ = true;
                    Computer.getComputer().getCpu().generateInterrupt();
                }
            }
        }
        if (this.timer2running) {
            --this.timer2counter;
            if (this.timer2counter < 0) {
                this.timer2running = false;
                this.timer2counter = this.timer2latch;
                if (this.timer2interruptEnabled) {
                    this.timer2IRQ = true;
                    Computer.getComputer().getCpu().generateInterrupt();
                }
            }
        }
        if (!this.timer1running && !this.timer2running) {
            this.setRun(false);
        }
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public void reconfigure() {
    }

    public void writeRegister(int reg, int value) {
        value &= 0xFF;
        Register r = Register.fromInt(reg);
        switch (r) {
            case ORB: {
                if (this.dataDirectionB == 0) break;
                this.sendOutputB(value &= this.dataDirectionB);
                break;
            }
            case ORA: {
                if (this.dataDirectionA == 0) break;
                this.sendOutputA(value &= this.dataDirectionA);
                break;
            }
            case DDRB: {
                this.dataDirectionB = value;
                break;
            }
            case DDRA: {
                this.dataDirectionA = value;
                break;
            }
            case T1CL: 
            case T1LL: {
                this.timer1latch = this.timer1latch & 0xFF00 | value;
                break;
            }
            case T1CH: {
                this.timer1latch = this.timer1latch & 0xFF | value << 8;
                this.timer1IRQ = false;
                this.timer1counter = this.timer1latch;
                this.timer1running = true;
                this.setRun(true);
                break;
            }
            case T1LH: {
                this.timer1latch = this.timer1latch & 0xFF | value << 8;
                this.timer1IRQ = false;
                break;
            }
            case T2CL: {
                this.timer2latch = this.timer2latch & 0xFF00 | value;
                break;
            }
            case T2CH: {
                this.timer2latch = this.timer2latch & 0xFF | value << 8;
                this.timer2IRQ = false;
                this.timer2counter = this.timer2latch;
                this.timer2running = true;
                this.setRun(true);
                break;
            }
            case SR: {
                break;
            }
            case ACR: {
                boolean bl = this.timer1freerun = (value & 0x40) != 0;
                if (!this.timer1freerun) break;
                this.timer1running = true;
                break;
            }
            case PCR: {
                break;
            }
            case IFR: {
                if ((value & 0x40) != 0) {
                    this.timer1IRQ = false;
                }
                if ((value & 0x20) == 0) break;
                this.timer2IRQ = false;
                break;
            }
            case IER: {
                boolean enable;
                boolean bl = enable = (value & 0x80) != 0;
                if ((value & 0x40) != 0) {
                    this.timer1interruptEnabled = enable;
                }
                if ((value & 0x20) == 0) break;
                this.timer2interruptEnabled = enable;
                break;
            }
        }
    }

    public abstract void sendOutputA(int var1);

    public abstract void sendOutputB(int var1);

    public int readRegister(int reg) {
        Register r = Register.fromInt(reg);
        switch (r) {
            case ORB: {
                if (this.dataDirectionB == 255) break;
                return this.receiveOutputB() & (this.dataDirectionB ^ 0xFF);
            }
            case ORA: 
            case ORAH: {
                if (this.dataDirectionA == 255) break;
                return this.receiveOutputA() & (this.dataDirectionA ^ 0xFF);
            }
            case DDRB: {
                return this.dataDirectionB;
            }
            case DDRA: {
                return this.dataDirectionA;
            }
            case T1CL: {
                this.timer1IRQ = false;
                this.timer1counter -= 8;
                return this.timer1counter & 0xFF;
            }
            case T1CH: {
                this.timer1counter -= 8;
                return (this.timer1counter & 0xFF00) >> 8;
            }
            case T1LL: {
                return this.timer1latch & 0xFF;
            }
            case T1LH: {
                return (this.timer1latch & 0xFF00) >> 8;
            }
            case T2CL: {
                this.timer2IRQ = false;
                return this.timer2counter & 0xFF;
            }
            case T2CH: {
                return (this.timer2counter & 0xFF00) >> 8;
            }
            case SR: {
                return 0;
            }
            case ACR: {
                if (this.timer1freerun) {
                    return 64;
                }
                return 0;
            }
            case PCR: {
                break;
            }
            case IFR: {
                int val = 0;
                if (this.timer1IRQ) {
                    val |= 0x40;
                }
                if (this.timer2IRQ) {
                    val |= 0x20;
                }
                if (val != 0) {
                    val |= 0x80;
                }
                return val;
            }
            case IER: {
                int val = 128;
                if (this.timer1interruptEnabled) {
                    val |= 0x40;
                }
                if (this.timer2interruptEnabled) {
                    val |= 0x20;
                }
                return val;
            }
        }
        return 0;
    }

    public abstract int receiveOutputA();

    public abstract int receiveOutputB();

    public static enum Register {
        ORB(0),
        ORA(1),
        DDRB(2),
        DDRA(3),
        T1CL(4),
        T1CH(5),
        T1LL(6),
        T1LH(7),
        T2CL(8),
        T2CH(9),
        SR(10),
        ACR(11),
        PCR(12),
        IFR(13),
        IER(14),
        ORAH(15);

        int val;

        private Register(int v) {
            this.val = v;
        }

        public static Register fromInt(int i) {
            for (Register r : Register.values()) {
                if (r.val != i) continue;
                return r;
            }
            return null;
        }
    }
}

