/*
 * Decompiled with CFR 0.152.
 */
package jace.tracker;

import jace.core.Utility;
import jace.tracker.UserInterface;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class EditableLabel
extends JPanel
implements MouseListener,
FocusListener {
    public static EditableLabel FOCUS;
    public static int DEFAULT_GAP;
    Component editComponent;
    JLabel labelComponent;
    CardLayout layout;
    boolean isEditing = false;
    int width = 4;
    Object ownerObject;
    String objectProperty;
    static KeyListener NAV_LISTENER;

    private void showBlankValue() {
        String s = "...................".substring(0, this.width);
        this.labelComponent.setText(s);
    }

    public EditableLabel(JLabel label, Component edit, int width, Object owner, String property) {
        this(label, edit, width, DEFAULT_GAP, DEFAULT_GAP, owner, property);
    }

    public EditableLabel(JLabel label, Component edit, int width, int horizontalPadding, int verticalPadding, Object owner, String property) {
        this.ownerObject = owner;
        this.width = width;
        this.objectProperty = property;
        this.addMouseListener(this);
        edit.addFocusListener(this);
        this.addFocusListener(this);
        this.layout = new CardLayout(horizontalPadding, verticalPadding);
        this.setLayout(this.layout);
        this.add((Component)label, cards.label.toString());
        this.add(edit, cards.edit.toString());
        this.labelComponent = label;
        this.editComponent = edit;
        this.deactivateEdit();
        this.setBackground(UserInterface.Theme.background.color);
        label.setForeground(UserInterface.Theme.foreground.color);
        label.setOpaque(false);
        edit.setBackground(UserInterface.Theme.backgroundEdit.color);
        edit.setForeground(UserInterface.Theme.foregroundEdit.color);
        edit.setFocusTraversalKeysEnabled(false);
        edit.addKeyListener(NAV_LISTENER);
        label.addKeyListener(NAV_LISTENER);
        this.addKeyListener(NAV_LISTENER);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mousePressed(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isEditing) {
            return;
        }
        this.activateEdit();
        final MouseEvent e2 = new MouseEvent(this.editComponent, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditableLabel.this.editComponent.dispatchEvent(e2);
            }
        });
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getComponent() == this || e.getComponent() == this.labelComponent || e.getComponent() == this.editComponent) {
            this.activateEdit();
        } else {
            this.deactivateEdit();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.deactivateEdit();
    }

    private void activateEdit() {
        FOCUS = this;
        this.isEditing = true;
        this.layout.show(this, cards.edit.toString());
        this.editComponent.requestFocusInWindow();
    }

    private void deactivateEdit() {
        this.isEditing = false;
        if (this.editComponent instanceof JTextField) {
            Object result;
            String value = ((JTextField)this.editComponent).getText();
            if (value != null && (value = value.trim()).length() > this.width) {
                value = value.substring(0, this.width);
            }
            String string = (result = Utility.setProperty(this.ownerObject, this.objectProperty, value, true)) == null ? null : (value = result instanceof Integer ? Integer.toString((Integer)result, 16) : result.toString());
            if (value != null && value.length() < this.width) {
                value = value.concat("          ".substring(0, this.width - value.length()));
            }
            if (value == null || value.equals("")) {
                this.showBlankValue();
                ((JTextField)this.editComponent).setText(null);
            } else {
                this.labelComponent.setText(value);
                ((JTextField)this.editComponent).setText(value.trim());
            }
        } else if (this.editComponent instanceof JComboBox) {
            ImageIcon selection = (ImageIcon)((JComboBox)this.editComponent).getSelectedItem();
            this.labelComponent.setText(selection.getDescription());
        }
        this.layout.show(this, cards.label.toString());
    }

    public static EditableLabel generateTextLabel(Object owner, String property, int width, KeyListener listener) {
        EditableLabel label = EditableLabel.generateTextLabel(owner, property, width);
        label.editComponent.addKeyListener(listener);
        return label;
    }

    public static EditableLabel generateTextLabel(Object owner, String property, int width) {
        Object value = Utility.getProperty(owner, property);
        JLabel label = new JLabel(value != null ? value.toString() : null);
        JTextField editor = new JTextField("");
        editor.setCaretColor(UserInterface.Theme.foregroundEdit.color);
        editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        label.setFont(UserInterface.EDITOR_FONT);
        editor.setFont(UserInterface.EDITOR_FONT);
        EditableLabel output = new EditableLabel(label, editor, width, owner, property);
        if (value == null || value.equals("")) {
            output.showBlankValue();
        }
        return output;
    }

    static {
        DEFAULT_GAP = 4;
        NAV_LISTENER = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 9: {
                        if (e.isShiftDown()) {
                            this.moveLeft();
                        } else {
                            this.moveRight();
                        }
                        e.consume();
                        break;
                    }
                    case 38: {
                        this.moveUp();
                        e.consume();
                        break;
                    }
                    case 40: {
                        this.moveDown();
                        e.consume();
                        break;
                    }
                }
            }

            public int getIndex(Component c) {
                System.out.println("Looking for " + c.getClass().getName() + " in parent " + c.getParent().getClass().getName());
                for (int i = 0; i < c.getParent().getComponentCount(); ++i) {
                    if (c != c.getParent().getComponent(i)) continue;
                    return i;
                }
                return -1;
            }

            public void focus(final Component c) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (c instanceof EditableLabel) {
                            ((EditableLabel)c).activateEdit();
                        } else {
                            c.requestFocusInWindow();
                        }
                    }
                };
                EventQueue.invokeLater(r);
            }

            public void moveDown() {
                EditableLabel c = FOCUS;
                int col = this.getIndex(c);
                int row = this.getIndex(c.getParent()) + 1;
                if (row < c.getParent().getParent().getComponentCount()) {
                    System.out.println("Trying to focus on col " + col + " row " + row);
                    this.focus(((Container)c.getParent().getParent().getComponent(row)).getComponent(col));
                }
            }

            public void moveUp() {
                EditableLabel c = FOCUS;
                int col = this.getIndex(c);
                int row = this.getIndex(c.getParent()) - 1;
                if (row >= 0) {
                    System.out.println("Trying to focus on col " + col + " row " + row);
                    this.focus(((Container)c.getParent().getParent().getComponent(row)).getComponent(col));
                }
            }

            public void moveLeft() {
                EditableLabel c = FOCUS;
                int col = this.getIndex(c) - 1;
                System.out.println("Trying to focus on col " + col);
                if (col >= 0) {
                    this.focus(c.getParent().getComponent(col));
                }
            }

            public void moveRight() {
                EditableLabel c = FOCUS;
                int col = this.getIndex(c) + 1;
                System.out.println("Trying to focus on col " + col);
                if (col < c.getParent().getComponentCount()) {
                    this.focus(c.getParent().getComponent(col));
                }
            }
        };
    }

    public static enum cards {
        label,
        edit;

    }
}

