/*
 * Decompiled with CFR 0.152.
 */
package jace.tracker;

import jace.core.Utility;
import jace.tracker.Command;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;

public class Row {
    static ImageIcon[] ENVELOPE_ICONS = new ImageIcon[EnvelopeShape.values().length];
    public EnumMap<Channel, ChannelData> channels = new EnumMap(Channel.class);
    public Integer ay1noisePeriod;
    public Integer ay2noisePeriod;
    public Integer ay1envelopePeriod;
    public Integer ay2envelopePeriod;
    public EnvelopeShape ay1envelopeShape;
    public EnvelopeShape ay2envelopeShape;
    public Set<Command> globalCommands = new HashSet<Command>();

    public Row() {
        for (Channel c : Channel.values()) {
            this.channels.put(c, new ChannelData());
        }
    }

    public boolean isEmpty() {
        for (ChannelData d : this.channels.values()) {
            if (d == null || d.isEmpty()) continue;
            return false;
        }
        if (this.ay1envelopePeriod != null || this.ay2envelopePeriod != null) {
            return false;
        }
        if (this.ay1envelopeShape != null || this.ay2envelopeShape != null) {
            return false;
        }
        if (this.ay1noisePeriod != null || this.ay2noisePeriod != null) {
            return false;
        }
        return this.globalCommands.isEmpty();
    }

    static {
        int i = 0;
        for (EnvelopeShape shape : EnvelopeShape.values()) {
            Row.ENVELOPE_ICONS[i++] = shape.getIcon();
        }
    }

    public static class ChannelData {
        public Note tone;
        public Integer volume;
        public Boolean toneActive;
        public Boolean noiseActive;
        public Boolean envelopeActive;
        public Set<Command> commands = new HashSet<Command>();

        public boolean isEmpty() {
            if (!this.commands.isEmpty()) {
                return false;
            }
            return this.tone == null && this.volume == null && this.toneActive == null && this.noiseActive == null && this.envelopeActive == null;
        }
    }

    public static enum Channel {
        A1,
        B1,
        C1,
        A2,
        B2,
        C2;

    }

    public static enum EnvelopeShape {
        unspecified(-1, ""),
        pulse(0, "|\\____"),
        pulseinv(4, "/|____"),
        saw(8, "|\\|\\|\\"),
        triangle(10, "\\/\\/\\/"),
        triangleinv(14, "/\\/\\/\\"),
        holdinv(11, "|\\|^^^"),
        hold(13, "/^^^^^");

        int value;
        String pattern;
        ImageIcon icon;

        private EnvelopeShape(int v, String p) {
            this.value = v;
            this.pattern = p;
        }

        ImageIcon getIcon() {
            if (this.icon == null) {
                this.icon = this.value >= 0 ? Utility.loadIcon("ayenvelope" + this.value + ".png") : new ImageIcon(new BufferedImage(64, 12, 6));
                this.icon.setDescription(this.toString());
            }
            return this.icon;
        }
    }

    public static enum Note {
        C0(3901),
        CS0(3682),
        D0(3476),
        DS0(3279),
        E0(3096),
        F0(2922),
        FS0(2759),
        G0(2603),
        GS0(2457),
        A0(2319),
        AS0(2189),
        B0(2066),
        C1(1950),
        CS1(1841),
        D1(1737),
        DS1(1640),
        E1(1548),
        F1(1461),
        FS1(1379),
        G1(1302),
        GS1(1229),
        A1(1160),
        AS1(1095),
        B1(1033),
        C2(975),
        CS2(920),
        D2(869),
        DS2(820),
        E2(774),
        F2(731),
        FS2(690),
        G2(651),
        GS2(614),
        A2(580),
        AS2(547),
        B2(517),
        C3(488),
        CS3(460),
        D3(434),
        DS3(410),
        E3(387),
        F3(365),
        FS3(345),
        G3(325),
        GS3(307),
        A3(290),
        AS3(274),
        B3(258),
        C4(244),
        CS4(230),
        D4(217),
        DS4(205),
        E4(193),
        F4(183),
        FS4(172),
        G4(163),
        GS4(154),
        A4(145),
        AS4(137),
        B4(129),
        C5(122),
        CS5(115),
        D5(109),
        DS5(102),
        E5(97),
        F5(91),
        FS5(86),
        G5(81),
        GS5(77),
        A5(72),
        AS5(68),
        B5(65),
        C6(61),
        CS6(58),
        D6(54),
        DS6(51),
        E6(48),
        F6(46),
        FS6(43),
        G6(41),
        GS6(38),
        A6(36),
        AS6(34),
        B6(32),
        C7(30),
        CS7(29),
        D7(27),
        DS7(26),
        E7(24),
        F7(23),
        FS7(22),
        G7(20),
        GS7(19),
        A7(18),
        AS7(17),
        B7(16),
        C8(15);

        int freq;

        private Note(int f) {
            this.freq = f;
        }

        public String toString() {
            return super.toString().replace("S", "#");
        }
    }
}

