/*
 * Decompiled with CFR 0.152.
 */
package jace.tracker;

import jace.tracker.EditableLabel;
import jace.tracker.Row;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UserInterface {
    static Font EDITOR_FONT = new Font("Monospaced", 0, 12);
    public static int BASE_OCTAVE = 3;
    public static final Map<Integer, Note> KEYBOARD_MAP = new HashMap<Integer, Note>();
    public static KeyAdapter toneListner;

    public static void main(String ... args) {
        Row r = new Row();
        JFrame testWindow = new JFrame();
        testWindow.setDefaultCloseOperation(3);
        testWindow.setSize(900, 600);
        Container content = testWindow.getContentPane();
        content.setLayout(new BoxLayout(testWindow.getContentPane(), 1));
        content.setBackground(Theme.background.color);
        content.setForeground(Theme.foreground.color);
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        content.add(UserInterface.createRowEditor(r));
        testWindow.setVisible(true);
    }

    public static Component createRowEditor(Row r) {
        JPanel rowEditor = new JPanel();
        rowEditor.setSize(800, 24);
        rowEditor.setLayout(new BoxLayout(rowEditor, 0));
        rowEditor.setBackground(Theme.background.color);
        rowEditor.setOpaque(true);
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.A1.tone", 3, toneListner));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.A1.volume", 1));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.A1.commands", 3));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.B1.tone", 3, toneListner));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.B1.volume", 1));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.B1.commands", 3));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.C1.tone", 3, toneListner));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.C1.volume", 1));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.C1.commands", 3));
        rowEditor.add(EditableLabel.generateTextLabel(r, "ay1noisePeriod", 4));
        rowEditor.add(EditableLabel.generateTextLabel(r, "ay1envelopePeriod", 4));
        rowEditor.add(UserInterface.generateEnvelopeEditor(r.ay1envelopeShape, r, "ay2envelopeShape"));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.A2.tone", 3, toneListner));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.A2.volume", 1));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.A2.commands", 3));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.B2.tone", 3, toneListner));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.B2.volume", 1));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.B2.commands", 3));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.C2.tone", 3, toneListner));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.C2.volume", 1));
        rowEditor.add(EditableLabel.generateTextLabel(r, "channels.C2.commands", 3));
        rowEditor.add(EditableLabel.generateTextLabel(r, "ay2noisePeriod", 4));
        rowEditor.add(EditableLabel.generateTextLabel(r, "ay2envelopePeriod", 4));
        rowEditor.add(UserInterface.generateEnvelopeEditor(r.ay2envelopeShape, r, "ay2envelopeShape"));
        rowEditor.add(EditableLabel.generateTextLabel(r, "globalCommands", 6));
        rowEditor.doLayout();
        return rowEditor;
    }

    public static Component generateEnvelopeEditor(Row.EnvelopeShape envelope, Row row, String property) {
        if (envelope == null) {
            envelope = Row.EnvelopeShape.unspecified;
        }
        JLabel label = new JLabel(envelope.icon){

            @Override
            public void setText(String text) {
                Row.EnvelopeShape e;
                try {
                    e = Row.EnvelopeShape.valueOf(text);
                }
                catch (Throwable ex) {
                    e = Row.EnvelopeShape.unspecified;
                }
                this.setIcon(e.getIcon());
            }
        };
        label.setText(envelope.toString());
        JComboBox<ImageIcon> editor = new JComboBox<ImageIcon>(Row.ENVELOPE_ICONS);
        EditableLabel result = new EditableLabel(label, editor, 64, row, property);
        return result;
    }

    static {
        KEYBOARD_MAP.put(90, Note.C0);
        KEYBOARD_MAP.put(83, Note.CS0);
        KEYBOARD_MAP.put(88, Note.D0);
        KEYBOARD_MAP.put(68, Note.DS0);
        KEYBOARD_MAP.put(67, Note.E0);
        KEYBOARD_MAP.put(86, Note.F0);
        KEYBOARD_MAP.put(71, Note.FS0);
        KEYBOARD_MAP.put(66, Note.G0);
        KEYBOARD_MAP.put(72, Note.GS0);
        KEYBOARD_MAP.put(78, Note.A0);
        KEYBOARD_MAP.put(74, Note.AS0);
        KEYBOARD_MAP.put(77, Note.B0);
        KEYBOARD_MAP.put(81, Note.C1);
        KEYBOARD_MAP.put(50, Note.CS1);
        KEYBOARD_MAP.put(87, Note.D1);
        KEYBOARD_MAP.put(51, Note.DS1);
        KEYBOARD_MAP.put(69, Note.E1);
        KEYBOARD_MAP.put(82, Note.F1);
        KEYBOARD_MAP.put(53, Note.FS1);
        KEYBOARD_MAP.put(84, Note.G1);
        KEYBOARD_MAP.put(54, Note.GS1);
        KEYBOARD_MAP.put(89, Note.A1);
        KEYBOARD_MAP.put(55, Note.AS1);
        KEYBOARD_MAP.put(85, Note.B1);
        KEYBOARD_MAP.put(73, Note.C2);
        KEYBOARD_MAP.put(57, Note.CS2);
        KEYBOARD_MAP.put(79, Note.D2);
        KEYBOARD_MAP.put(48, Note.DS2);
        KEYBOARD_MAP.put(80, Note.E2);
        toneListner = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JTextField field = (JTextField)e.getSource();
                if (KEYBOARD_MAP.containsKey(e.getKeyCode())) {
                    Note n = KEYBOARD_MAP.get(e.getKeyCode());
                    String noteval = n.note;
                    int octave = BASE_OCTAVE + n.octaveOffset;
                    noteval = noteval + octave;
                    try {
                        Row.Note.valueOf(noteval);
                        field.setText(noteval);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                e.consume();
                field.setFocusable(false);
                field.setFocusable(true);
            }
        };
    }

    public static enum Note {
        C0("C", -1),
        CS0("CS", -1),
        D0("D", -1),
        DS0("DS", -1),
        E0("E", -1),
        F0("F", -1),
        FS0("FS", -1),
        G0("G", -1),
        GS0("GS", -1),
        A0("A", -1),
        AS0("AS", -1),
        B0("B", -1),
        C1("C", 0),
        CS1("CS", 0),
        D1("D", 0),
        DS1("DS", 0),
        E1("E", 0),
        F1("F", 0),
        FS1("FS", 0),
        G1("G", 0),
        GS1("GS", 0),
        A1("A", 0),
        AS1("AS", 0),
        B1("B", 0),
        C2("C", 1),
        CS2("CS", 1),
        D2("D", 1),
        DS2("DS", 1),
        E2("E", 1);

        public String note;
        public int octaveOffset;

        private Note(String n2, int offset) {
            this.note = n2;
            this.octaveOffset = offset;
        }
    }

    public static enum Theme {
        background(0),
        foreground(0xFFFFFF),
        backgroundEdit(128),
        foregroundEdit(0xFFFF80);

        Color color;

        private Theme(int col) {
            this.color = new Color(col & 0xFFFFFF);
        }
    }
}

