/*
 * Decompiled with CFR 0.152.
 */
package jace.ui;

import jace.config.ConfigurableField;
import jace.config.Reconfigurable;
import jace.core.Computer;
import jace.ui.DebuggerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public abstract class AbstractEmulatorFrame
extends JFrame
implements Reconfigurable {
    @ConfigurableField(name="Show Debug Panel")
    public Boolean showDebug = false;
    public static int DEFAULT_INDICATOR_TIME = 250;
    Lock indicatorLock = new ReentrantLock();
    Thread indicatorThread;
    Set<ImageIcon> visibleIndicators;
    private Map<ImageIcon, Long> removeTime = new HashMap<ImageIcon, Long>();
    private Map<Object, Set<ImageIcon>> indicators = new HashMap<Object, Set<ImageIcon>>();
    boolean fullscreenEnforceRatio = false;
    boolean isFullscreen = false;

    public AbstractEmulatorFrame() {
        this.initComponents();
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.getScreen().addKeyListener(l);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.pack();
    }

    @Override
    public abstract String getShortName();

    @Override
    public void reconfigure() {
        this.getDebuggerPanel().setVisible(this.isShowDebug());
        this.resizeVideo();
    }

    public abstract DebuggerPanel getDebuggerPanel();

    public boolean isShowDebug() {
        return this.showDebug;
    }

    public void setShowDebug(boolean showDebug) {
        this.showDebug = showDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndicator(Object owner, ImageIcon icon, int time) {
        Map<Object, Set<ImageIcon>> map = this.indicators;
        synchronized (map) {
            Set<ImageIcon> ind = this.indicators.get(owner);
            if (ind == null) {
                ind = new HashSet<ImageIcon>();
                this.indicators.put(owner, ind);
            }
            this.removeTime.put(icon, System.currentTimeMillis() + (long)time);
            if (ind.contains(icon)) {
                return;
            }
            ind.add(icon);
        }
        this.redrawIndicators();
    }

    public void addIndicator(Object owner, ImageIcon icon) {
        this.addIndicator(owner, icon, DEFAULT_INDICATOR_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndicator(Object owner, ImageIcon icon, boolean redraw) {
        Map<Object, Set<ImageIcon>> map = this.indicators;
        synchronized (map) {
            Set<ImageIcon> ind = this.indicators.get(owner);
            if (ind != null) {
                ind.remove(icon);
            }
            this.removeTime.remove(icon);
        }
        if (redraw) {
            this.redrawIndicators();
        }
    }

    public void removeIndicator(Object owner, ImageIcon icon) {
        this.removeIndicator(owner, icon, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndicators(Object owner) {
        Map<Object, Set<ImageIcon>> map = this.indicators;
        synchronized (map) {
            Set<ImageIcon> ind = this.indicators.get(owner);
            if (ind == null) {
                return;
            }
            for (ImageIcon i : ind) {
                this.removeTime.remove(i);
            }
            this.indicators.remove(owner);
        }
        this.redrawIndicators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redrawIndicators() {
        HashSet<ImageIcon> i = new HashSet<ImageIcon>();
        HashSet<ImageIcon> removeList = new HashSet<ImageIcon>();
        long now = System.currentTimeMillis();
        long soonest = Long.MAX_VALUE;
        Map<Object, Set<ImageIcon>> map = this.indicators;
        synchronized (map) {
            for (Object owner : this.indicators.keySet()) {
                Set<ImageIcon> ind = this.indicators.get(owner);
                for (ImageIcon icon : ind) {
                    long rt = this.removeTime.get(icon);
                    if (rt <= now) {
                        removeList.add(icon);
                        continue;
                    }
                    i.add(icon);
                    if (rt >= soonest) continue;
                    soonest = rt;
                }
                for (ImageIcon remove : removeList) {
                    this.removeIndicator(owner, remove, false);
                }
            }
        }
        boolean changed = false;
        if (this.visibleIndicators == null) {
            changed = true;
        } else if (i.size() != this.visibleIndicators.size() || !i.containsAll(this.visibleIndicators)) {
            changed = true;
        }
        if (changed) {
            this.visibleIndicators = i;
            this.doRedrawIndicators(this.visibleIndicators);
        }
        this.resumeIndicatorLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeIndicatorLoop() {
        try {
            this.indicatorLock.lock();
            if (this.indicatorThread == null || !this.indicatorThread.isAlive()) {
                this.indicatorThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (AbstractEmulatorFrame.this.visibleIndicators != null) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ex) {
                                return;
                            }
                            AbstractEmulatorFrame.this.redrawIndicators();
                            if (!AbstractEmulatorFrame.this.visibleIndicators.isEmpty()) continue;
                            AbstractEmulatorFrame.this.visibleIndicators = null;
                        }
                    }
                });
                this.indicatorThread.start();
            }
        }
        finally {
            this.indicatorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendIndicatorLoop() {
        try {
            this.indicatorLock.lock();
            this.visibleIndicators.clear();
            this.indicatorThread.interrupt();
            this.indicatorThread = null;
        }
        finally {
            this.indicatorLock.unlock();
        }
    }

    public abstract void doRedrawIndicators(Set<ImageIcon> var1);

    public void resizeVideo() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Computer.pause();
                Computer.getComputer().getVideo().suspend();
                DebuggerPanel debugger = AbstractEmulatorFrame.this.getDebuggerPanel();
                Component screen = AbstractEmulatorFrame.this.getScreen();
                Rectangle bounds = screen.getParent().getBounds();
                int width = (int)bounds.getWidth();
                int height = (int)bounds.getHeight();
                if (debugger.isVisible()) {
                    debugger.setBounds(width - debugger.getWidth(), 0, debugger.getWidth(), height);
                    width = (int)bounds.getWidth() - debugger.getWidth() + 1;
                    screen.setSize(width, height);
                    debugger.revalidate();
                } else {
                    screen.setSize(width, height);
                }
                Computer.getComputer().getVideo().setWidth(width);
                Computer.getComputer().getVideo().setHeight(height);
                if (!AbstractEmulatorFrame.this.isFullscreen || !AbstractEmulatorFrame.this.fullscreenEnforceRatio) {
                    Computer.getComputer().getVideo().setScreen(AbstractEmulatorFrame.this.getScreenGraphics());
                }
                Computer.getComputer().getVideo().forceRefresh();
                screen.validate();
                screen.requestFocusInWindow();
                Computer.resume();
                Computer.getComputer().getVideo().resume();
            }
        });
    }

    public abstract Component getScreen();

    public void enforceIntegerRatio() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int vscale;
                int ww = AbstractEmulatorFrame.this.getWidth();
                int wh = AbstractEmulatorFrame.this.getHeight();
                int w = AbstractEmulatorFrame.this.getContentPane().getWidth();
                int h = AbstractEmulatorFrame.this.getContentPane().getHeight();
                int bw = ww - w;
                int bh = wh - h;
                double dhscale = (double)w / 560.0;
                double dvscale = (double)h / 384.0;
                int hscale = (int)Math.round(dhscale);
                int scale = Math.min(hscale, vscale = (int)Math.round(dvscale));
                if (scale < 1) {
                    scale = 1;
                }
                Rectangle b = AbstractEmulatorFrame.this.getBounds();
                if (!AbstractEmulatorFrame.this.isFullscreen) {
                    b.setSize(bw + 560 * scale, bh + 384 * scale);
                    AbstractEmulatorFrame.this.setBounds(b);
                } else {
                    boolean bl = AbstractEmulatorFrame.this.fullscreenEnforceRatio = !AbstractEmulatorFrame.this.fullscreenEnforceRatio;
                    if (AbstractEmulatorFrame.this.fullscreenEnforceRatio) {
                        int sw = AbstractEmulatorFrame.this.getBounds().width;
                        int sh = AbstractEmulatorFrame.this.getBounds().height;
                        while (560 * scale > sw || 384 * scale > sh) {
                            --scale;
                        }
                        b.setSize(560 * scale, 384 * scale);
                        b.x = w / 2 - b.width / 2;
                        b.y = h / 2 - b.height / 2;
                        Computer.pause();
                        Computer.getComputer().getVideo().suspend();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        Graphics2D g = AbstractEmulatorFrame.this.getScreenGraphics();
                        g.setColor(new Color(0, 0, 64));
                        g.fill(AbstractEmulatorFrame.this.getBounds());
                        Graphics2D gg = (Graphics2D)g.create(b.x, b.y, b.width, b.height);
                        gg.scale((double)b.width / (double)sw, (double)b.height / (double)sh);
                        Computer.getComputer().getVideo().setScreen(gg);
                        Computer.getComputer().getVideo().resume();
                        Computer.resume();
                    } else {
                        b = AbstractEmulatorFrame.this.getBounds();
                        AbstractEmulatorFrame.this.getScreen().setBounds(AbstractEmulatorFrame.this.getBounds());
                    }
                }
                AbstractEmulatorFrame.this.resizeVideo();
            }
        });
    }

    public abstract void repaintIndicators();

    public Graphics2D getScreenGraphics() {
        return (Graphics2D)this.getScreen().getGraphics();
    }

    public void toggleFullscreen() {
        final AbstractEmulatorFrame window = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Computer.pause();
                Computer.getComputer().getVideo().suspend();
                AbstractEmulatorFrame.this.isFullscreen = !AbstractEmulatorFrame.this.isFullscreen;
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                if (AbstractEmulatorFrame.this.isFullscreen) {
                    AbstractEmulatorFrame.this.removeNotify();
                    AbstractEmulatorFrame.this.setUndecorated(true);
                    AbstractEmulatorFrame.this.addNotify();
                    device.setFullScreenWindow(window);
                    AbstractEmulatorFrame.this.fullscreenEnforceRatio = false;
                } else {
                    AbstractEmulatorFrame.this.removeNotify();
                    AbstractEmulatorFrame.this.setUndecorated(false);
                    AbstractEmulatorFrame.this.addNotify();
                    device.setFullScreenWindow(null);
                }
                AbstractEmulatorFrame.this.resizeVideo();
                Computer.getComputer().getVideo().resume();
                Computer.resume();
            }
        });
    }
}

