PImage normal_jiggly, big_jiggly, yellow_jiggly;
PImage current_image;
int counter;

void setup(){ // Happens only once.
 size(500, 600);
 background(178,229,229); // r, g, b
 frameRate(20);
 imageMode(CENTER);
 
 // Loading three images.
 normal_jiggly = loadImage("stamp1.png");        // 1
 big_jiggly    = loadImage("stamp1.png");   // 2
 yellow_jiggly = loadImage("stamp1.png"); // 3
  
 counter = 0;
 current_image = normal_jiggly;
}

void draw(){ // Repeats every frame. (60 fps)
  if(mousePressed){ // Is the mouse button being pressed down?
    make_stroke(); // Runs the instructions at the bottom.
  }
}

void mousePressed(){ 
/*Happens when mouse gets pressed.*/

  switch(counter){
    case 0:
      current_image = normal_jiggly;
    break;
    
    case 1:
      current_image = big_jiggly;
    break;
    
    case 2:
      current_image = yellow_jiggly;
    break;
  }

  counter = counter + 1;
  if(counter > 2){
    counter = 0;
  }
}

void mouseReleased(){ /* Happens when mouse gets released.*/ }

void make_stroke(){
  image(current_image, mouseX, mouseY); 
}

/* How to respond to mouse speed.
void make_stroke(){ 
  PVector mousePos = new PVector(mouseX, mouseY); // Vector / Point / Tuple
  PVector pmousePos = new PVector(pmouseX, pmouseY); 
  float distance = mousePos.dist(pmousePos);
  println(distance);
  strokeWeight(distance);
  line(pmouseX, pmouseY, mouseX, mouseY);
}
*/

/* How to respond to mouse position on screen.
void make_stroke(){
  line(pmouseX, pmouseY, mouseX, mouseY);
  float x = mouseX / float(width);
  float y = mouseY / float(height);
  println(x, y);
  stroke(y * 255, 0, 0);
  strokeWeight(x * 10);
}
*/














