/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.oa.poa.Policies;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.EventHandlerBase;
import com.sun.corba.se.impl.transport.SocketOrChannelConnectionImpl;
import com.sun.corba.se.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.se.pept.broker.Broker;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.EventHandler;
import com.sun.corba.se.pept.transport.InboundConnectionCache;
import com.sun.corba.se.pept.transport.Selector;
import com.sun.corba.se.spi.extension.RequestPartitioningPolicy;
import com.sun.corba.se.spi.ior.IORTemplate;
import com.sun.corba.se.spi.ior.TaggedProfileTemplate;
import com.sun.corba.se.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPFactories;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaAcceptor;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.SocketInfo;
import com.sun.corba.se.spi.transport.SocketOrChannelAcceptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import sun.corba.OutputStreamFactory;

public class SocketOrChannelAcceptorImpl
extends EventHandlerBase
implements CorbaAcceptor,
SocketOrChannelAcceptor,
Work,
SocketInfo,
LegacyServerSocketEndPointInfo {
    protected ServerSocketChannel serverSocketChannel;
    protected ServerSocket serverSocket;
    protected int port;
    protected long enqueueTime;
    protected boolean initialized;
    protected ORBUtilSystemException wrapper;
    protected InboundConnectionCache connectionCache;
    protected String type = "";
    protected String name = "";
    protected String hostname;
    protected int locatorPort;

    public SocketOrChannelAcceptorImpl(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
        this.setWork(this);
        this.initialized = false;
        this.hostname = oRB.getORBData().getORBServerHost();
        this.name = "NO_NAME";
        this.locatorPort = -1;
    }

    public SocketOrChannelAcceptorImpl(ORB oRB, int n) {
        this(oRB);
        this.port = n;
    }

    public SocketOrChannelAcceptorImpl(ORB oRB, int n, String string, String string2) {
        this(oRB, n);
        this.name = string;
        this.type = string2;
    }

    @Override
    public boolean initialize() {
        if (this.initialized) {
            return false;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".initialize: " + this);
        }
        InetSocketAddress inetSocketAddress = null;
        try {
            if (this.orb.getORBData().getListenOnAllInterfaces().equals("com.sun.CORBA.INTERNAL USE ONLY: listen on all interfaces")) {
                inetSocketAddress = new InetSocketAddress(this.port);
            } else {
                String string = this.orb.getORBData().getORBServerHost();
                inetSocketAddress = new InetSocketAddress(string, this.port);
            }
            this.serverSocket = this.orb.getORBData().getSocketFactory().createServerSocket(this.type, inetSocketAddress);
            this.internalInitialize();
        }
        catch (Throwable throwable) {
            throw this.wrapper.createListenerFailed(throwable, (Object)Integer.toString(this.port));
        }
        this.initialized = true;
        return true;
    }

    protected void internalInitialize() throws Exception {
        this.port = this.serverSocket.getLocalPort();
        this.orb.getCorbaTransportManager().getInboundConnectionCache(this);
        this.serverSocketChannel = this.serverSocket.getChannel();
        if (this.serverSocketChannel != null) {
            this.setUseSelectThreadToWait(this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
            this.serverSocketChannel.configureBlocking(!this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
        } else {
            this.setUseSelectThreadToWait(false);
        }
        this.setUseWorkerThreadForEvent(this.orb.getORBData().acceptorSocketUseWorkerThreadForEvent());
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public String getConnectionCacheType() {
        return this.getClass().toString();
    }

    @Override
    public void setConnectionCache(InboundConnectionCache inboundConnectionCache) {
        this.connectionCache = inboundConnectionCache;
    }

    @Override
    public InboundConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public boolean shouldRegisterAcceptEvent() {
        return true;
    }

    @Override
    public void accept() {
        try {
            SocketChannel socketChannel = null;
            Socket socket = null;
            if (this.serverSocketChannel == null) {
                socket = this.serverSocket.accept();
            } else {
                socketChannel = this.serverSocketChannel.accept();
                socket = socketChannel.socket();
            }
            this.orb.getORBData().getSocketFactory().setAcceptedSocketOptions(this, this.serverSocket, socket);
            if (this.orb.transportDebugFlag) {
                this.dprint(".accept: " + (this.serverSocketChannel == null ? this.serverSocket.toString() : this.serverSocketChannel.toString()));
            }
            SocketOrChannelConnectionImpl socketOrChannelConnectionImpl = new SocketOrChannelConnectionImpl(this.orb, this, socket);
            if (this.orb.transportDebugFlag) {
                this.dprint(".accept: new: " + socketOrChannelConnectionImpl);
            }
            this.getConnectionCache().put(this, socketOrChannelConnectionImpl);
            if (socketOrChannelConnectionImpl.shouldRegisterServerReadEvent()) {
                Selector selector = this.orb.getTransportManager().getSelector(0);
                selector.registerForEvent(socketOrChannelConnectionImpl.getEventHandler());
            }
            this.getConnectionCache().reclaim();
        }
        catch (IOException iOException) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".accept:", iOException);
            }
            this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
            this.orb.getTransportManager().getSelector(0).registerForEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->:");
            }
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.unregisterForEvent(this);
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close:", iOException);
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-:");
            }
        }
    }

    @Override
    public EventHandler getEventHandler() {
        return this;
    }

    @Override
    public String getObjectAdapterId() {
        return null;
    }

    @Override
    public String getObjectAdapterManagerId() {
        return null;
    }

    @Override
    public void addToIORTemplate(IORTemplate iORTemplate, Policies policies, String string) {
        Iterator iterator = iORTemplate.iteratorById(0);
        String string2 = this.orb.getORBData().getORBServerHost();
        if (iterator.hasNext()) {
            IIOPAddress iIOPAddress = IIOPFactories.makeIIOPAddress(this.orb, string2, this.port);
            AlternateIIOPAddressComponent alternateIIOPAddressComponent = IIOPFactories.makeAlternateIIOPAddressComponent(iIOPAddress);
            while (iterator.hasNext()) {
                TaggedProfileTemplate taggedProfileTemplate = (TaggedProfileTemplate)iterator.next();
                taggedProfileTemplate.add(alternateIIOPAddressComponent);
            }
        } else {
            GIOPVersion gIOPVersion = this.orb.getORBData().getGIOPVersion();
            int n = policies.forceZeroPort() ? 0 : (policies.isTransient() ? this.port : this.orb.getLegacyServerSocketManager().legacyGetPersistentServerPort("IIOP_CLEAR_TEXT"));
            IIOPAddress iIOPAddress = IIOPFactories.makeIIOPAddress(this.orb, string2, n);
            IIOPProfileTemplate iIOPProfileTemplate = IIOPFactories.makeIIOPProfileTemplate(this.orb, gIOPVersion, iIOPAddress);
            if (gIOPVersion.supportsIORIIOPProfileComponents()) {
                iIOPProfileTemplate.add(IIOPFactories.makeCodeSetsComponent(this.orb));
                iIOPProfileTemplate.add(IIOPFactories.makeMaxStreamFormatVersionComponent());
                RequestPartitioningPolicy requestPartitioningPolicy = (RequestPartitioningPolicy)policies.get_effective_policy(0x53550003);
                if (requestPartitioningPolicy != null) {
                    iIOPProfileTemplate.add(IIOPFactories.makeRequestPartitioningComponent(requestPartitioningPolicy.getValue()));
                }
                if (string != null && string != "") {
                    iIOPProfileTemplate.add(IIOPFactories.makeJavaCodebaseComponent(string));
                }
                if (this.orb.getORBData().isJavaSerializationEnabled()) {
                    iIOPProfileTemplate.add(IIOPFactories.makeJavaSerializationComponent());
                }
            }
            iORTemplate.add(iIOPProfileTemplate);
        }
    }

    @Override
    public String getMonitoringName() {
        return "AcceptedConnections";
    }

    @Override
    public SelectableChannel getChannel() {
        return this.serverSocketChannel;
    }

    @Override
    public int getInterestOps() {
        return 16;
    }

    @Override
    public Acceptor getAcceptor() {
        return this;
    }

    @Override
    public Connection getConnection() {
        throw new RuntimeException("Should not happen.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork->: " + this);
            }
            if (this.selectionKey.isAcceptable()) {
                this.accept();
            } else if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ! selectionKey.isAcceptable: " + this);
            }
        }
        catch (SecurityException securityException) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring SecurityException: " + securityException + " " + this);
            }
            String string = ORBUtility.getClassSecurityInfo(this.getClass());
            this.wrapper.securityExceptionInAccept(securityException, string);
        }
        catch (Exception exception) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Exception: " + exception + " " + this);
            }
            this.wrapper.exceptionInAccept(exception);
        }
        catch (Throwable throwable) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Throwable: " + throwable + " " + this);
            }
        }
        finally {
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.registerInterestOps(this);
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork<-:" + this);
            }
        }
    }

    @Override
    public void setEnqueueTime(long l) {
        this.enqueueTime = l;
    }

    @Override
    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    @Override
    public MessageMediator createMessageMediator(Broker broker, Connection connection) {
        SocketOrChannelContactInfoImpl socketOrChannelContactInfoImpl = new SocketOrChannelContactInfoImpl();
        return socketOrChannelContactInfoImpl.createMessageMediator(broker, connection);
    }

    @Override
    public MessageMediator finishCreatingMessageMediator(Broker broker, Connection connection, MessageMediator messageMediator) {
        SocketOrChannelContactInfoImpl socketOrChannelContactInfoImpl = new SocketOrChannelContactInfoImpl();
        return socketOrChannelContactInfoImpl.finishCreatingMessageMediator(broker, connection, messageMediator);
    }

    @Override
    public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return new CDRInputObject((ORB)broker, (CorbaConnection)messageMediator.getConnection(), corbaMessageMediator.getDispatchBuffer(), corbaMessageMediator.getDispatchHeader());
    }

    @Override
    public OutputObject createOutputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return OutputStreamFactory.newCDROutputObject((ORB)broker, corbaMessageMediator, corbaMessageMediator.getReplyHeader(), corbaMessageMediator.getStreamFormatVersion());
    }

    @Override
    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public String toString() {
        String string = this.serverSocketChannel == null ? (this.serverSocket == null ? "(not initialized)" : this.serverSocket.toString()) : this.serverSocketChannel.toString();
        return this.toStringName() + "[" + string + " " + this.type + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + "]";
    }

    protected String toStringName() {
        return "SocketOrChannelAcceptorImpl";
    }

    protected void dprint(String string) {
        ORBUtility.dprint(this.toStringName(), string);
    }

    protected void dprint(String string, Throwable throwable) {
        this.dprint(string);
        throwable.printStackTrace(System.out);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public String getHost() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getLocatorPort() {
        return this.locatorPort;
    }

    @Override
    public void setLocatorPort(int n) {
        this.locatorPort = n;
    }

    @Override
    public String getName() {
        String string = this.name.equals("NO_NAME") ? this.toString() : this.name;
        return string;
    }
}

