/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.LayoutQueue;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AsyncBoxView
extends View {
    int axis;
    List<ChildState> stats = new ArrayList<ChildState>();
    float majorSpan;
    boolean estimatedMajorSpan;
    float minorSpan;
    protected ChildLocator locator;
    float topInset;
    float bottomInset;
    float leftInset;
    float rightInset;
    ChildState minRequest;
    ChildState prefRequest;
    boolean majorChanged;
    boolean minorChanged;
    Runnable flushTask;
    ChildState changing;

    public AsyncBoxView(Element element, int n) {
        super(element);
        this.axis = n;
        this.locator = new ChildLocator();
        this.flushTask = new FlushTask();
        this.minorSpan = 32767.0f;
        this.estimatedMajorSpan = false;
    }

    public int getMajorAxis() {
        return this.axis;
    }

    public int getMinorAxis() {
        return this.axis == 0 ? 1 : 0;
    }

    public float getTopInset() {
        return this.topInset;
    }

    public void setTopInset(float f) {
        this.topInset = f;
    }

    public float getBottomInset() {
        return this.bottomInset;
    }

    public void setBottomInset(float f) {
        this.bottomInset = f;
    }

    public float getLeftInset() {
        return this.leftInset;
    }

    public void setLeftInset(float f) {
        this.leftInset = f;
    }

    public float getRightInset() {
        return this.rightInset;
    }

    public void setRightInset(float f) {
        this.rightInset = f;
    }

    protected float getInsetSpan(int n) {
        float f = n == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
        return f;
    }

    protected void setEstimatedMajorSpan(boolean bl) {
        this.estimatedMajorSpan = bl;
    }

    protected boolean getEstimatedMajorSpan() {
        return this.estimatedMajorSpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChildState getChildState(int n) {
        List<ChildState> list = this.stats;
        synchronized (list) {
            if (n >= 0 && n < this.stats.size()) {
                return this.stats.get(n);
            }
            return null;
        }
    }

    protected LayoutQueue getLayoutQueue() {
        return LayoutQueue.getDefaultQueue();
    }

    protected ChildState createChildState(View view) {
        return new ChildState(view);
    }

    protected synchronized void majorRequirementChange(ChildState childState, float f) {
        if (!this.estimatedMajorSpan) {
            this.majorSpan += f;
        }
        this.majorChanged = true;
    }

    protected synchronized void minorRequirementChange(ChildState childState) {
        this.minorChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushRequirementChanges() {
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        try {
            abstractDocument.readLock();
            View view = null;
            boolean bl = false;
            boolean bl2 = false;
            Object object = this;
            synchronized (object) {
                List<ChildState> list = this.stats;
                synchronized (list) {
                    int n = this.getViewCount();
                    if (n > 0 && (this.minorChanged || this.estimatedMajorSpan)) {
                        LayoutQueue layoutQueue = this.getLayoutQueue();
                        ChildState childState = this.getChildState(0);
                        ChildState childState2 = this.getChildState(0);
                        float f = 0.0f;
                        for (int i = 1; i < n; ++i) {
                            ChildState childState3 = this.getChildState(i);
                            if (this.minorChanged) {
                                if (childState3.min > childState.min) {
                                    childState = childState3;
                                }
                                if (childState3.pref > childState2.pref) {
                                    childState2 = childState3;
                                }
                            }
                            if (!this.estimatedMajorSpan) continue;
                            f += childState3.getMajorSpan();
                        }
                        if (this.minorChanged) {
                            this.minRequest = childState;
                            this.prefRequest = childState2;
                        }
                        if (this.estimatedMajorSpan) {
                            this.majorSpan = f;
                            this.estimatedMajorSpan = false;
                            this.majorChanged = true;
                        }
                    }
                }
                if (this.majorChanged || this.minorChanged) {
                    view = this.getParent();
                    if (view != null) {
                        if (this.axis == 0) {
                            bl = this.majorChanged;
                            bl2 = this.minorChanged;
                        } else {
                            bl2 = this.majorChanged;
                            bl = this.minorChanged;
                        }
                    }
                    this.majorChanged = false;
                    this.minorChanged = false;
                }
            }
            if (view != null) {
                view.preferenceChanged(this, bl, bl2);
                object = this.getContainer();
                if (object != null) {
                    ((Component)object).repaint();
                }
            }
        }
        finally {
            abstractDocument.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(int n, int n2, View[] viewArray) {
        List<ChildState> list = this.stats;
        synchronized (list) {
            for (int i = 0; i < n2; ++i) {
                ChildState childState = this.stats.remove(n);
                float f = childState.getMajorSpan();
                childState.getChildView().setParent(null);
                if (f == 0.0f) continue;
                this.majorRequirementChange(childState, -f);
            }
            LayoutQueue layoutQueue = this.getLayoutQueue();
            if (viewArray != null) {
                for (int i = 0; i < viewArray.length; ++i) {
                    ChildState childState = this.createChildState(viewArray[i]);
                    this.stats.add(n + i, childState);
                    layoutQueue.addTask(childState);
                }
            }
            layoutQueue.addTask(this.flushTask);
        }
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                viewArray[i] = viewFactory.create(element.getElement(i));
            }
            this.replace(0, 0, viewArray);
        }
    }

    protected synchronized int getViewIndexAtPosition(int n, Position.Bias bias) {
        boolean bl = bias == Position.Bias.Backward;
        n = bl ? Math.max(0, n - 1) : n;
        Element element = this.getElement();
        return element.getElementIndex(n);
    }

    @Override
    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null) {
            int n = Math.max(elementChange.getIndex() - 1, 0);
            ChildState childState = this.getChildState(n);
            this.locator.childChanged(childState);
        }
    }

    @Override
    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.getViewCount() == 0) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    @Override
    public synchronized void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (view == null) {
            this.getParent().preferenceChanged(this, bl, bl2);
        } else {
            View view2;
            if (this.changing != null && (view2 = this.changing.getChildView()) == view) {
                this.changing.preferenceChanged(bl, bl2);
                return;
            }
            int n = this.getViewIndex(view.getStartOffset(), Position.Bias.Forward);
            ChildState childState = this.getChildState(n);
            childState.preferenceChanged(bl, bl2);
            LayoutQueue layoutQueue = this.getLayoutQueue();
            layoutQueue.addTask(childState);
            layoutQueue.addTask(this.flushTask);
        }
    }

    @Override
    public void setSize(float f, float f2) {
        this.setSpanOnAxis(0, f);
        this.setSpanOnAxis(1, f2);
    }

    float getSpanOnAxis(int n) {
        if (n == this.getMajorAxis()) {
            return this.majorSpan;
        }
        return this.minorSpan;
    }

    void setSpanOnAxis(int n, float f) {
        float f2 = this.getInsetSpan(n);
        if (n == this.getMinorAxis()) {
            float f3 = f - f2;
            if (f3 != this.minorSpan) {
                this.minorSpan = f3;
                int n2 = this.getViewCount();
                if (n2 != 0) {
                    LayoutQueue layoutQueue = this.getLayoutQueue();
                    for (int i = 0; i < n2; ++i) {
                        ChildState childState = this.getChildState(i);
                        childState.childSizeValid = false;
                        layoutQueue.addTask(childState);
                    }
                    layoutQueue.addTask(this.flushTask);
                }
            }
        } else if (this.estimatedMajorSpan) {
            this.majorSpan = f - f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics, Shape shape) {
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            this.locator.setAllocation(shape);
            this.locator.paintChildren(graphics);
        }
    }

    @Override
    public float getPreferredSpan(int n) {
        float f = this.getInsetSpan(n);
        if (n == this.axis) {
            return this.majorSpan + f;
        }
        if (this.prefRequest != null) {
            View view = this.prefRequest.getChildView();
            return view.getPreferredSpan(n) + f;
        }
        return f + 30.0f;
    }

    @Override
    public float getMinimumSpan(int n) {
        if (n == this.axis) {
            return this.getPreferredSpan(n);
        }
        if (this.minRequest != null) {
            View view = this.minRequest.getChildView();
            return view.getMinimumSpan(n);
        }
        if (n == 0) {
            return this.getLeftInset() + this.getRightInset() + 5.0f;
        }
        return this.getTopInset() + this.getBottomInset() + 5.0f;
    }

    @Override
    public float getMaximumSpan(int n) {
        if (n == this.axis) {
            return this.getPreferredSpan(n);
        }
        return 2.1474836E9f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getViewCount() {
        List<ChildState> list = this.stats;
        synchronized (list) {
            return this.stats.size();
        }
    }

    @Override
    public View getView(int n) {
        ChildState childState = this.getChildState(n);
        if (childState != null) {
            return childState.getChildView();
        }
        return null;
    }

    @Override
    public Shape getChildAllocation(int n, Shape shape) {
        Shape shape2 = this.locator.getChildAllocation(n, shape);
        return shape2;
    }

    @Override
    public int getViewIndex(int n, Position.Bias bias) {
        return this.getViewIndexAtPosition(n, bias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        ChildState childState;
        int n2 = this.getViewIndex(n, bias);
        Shape shape2 = this.locator.getChildAllocation(n2, shape);
        ChildState childState2 = childState = this.getChildState(n2);
        synchronized (childState2) {
            View view = childState.getChildView();
            Shape shape3 = view.modelToView(n, shape2, bias);
            return shape3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        int n;
        Shape shape2;
        int n2;
        Object object = this.locator;
        synchronized (object) {
            n2 = this.locator.getViewIndexAtPoint(f, f2, shape);
            shape2 = this.locator.getChildAllocation(n2, shape);
        }
        Object object2 = object = this.getChildState(n2);
        synchronized (object2) {
            View view = ((ChildState)object).getChildView();
            n = view.viewToModel(f, f2, shape2, biasArray);
        }
        return n;
    }

    @Override
    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return Utilities.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    class FlushTask
    implements Runnable {
        FlushTask() {
        }

        @Override
        public void run() {
            AsyncBoxView.this.flushRequirementChanges();
        }
    }

    public class ChildState
    implements Runnable {
        private float min;
        private float pref;
        private float max;
        private boolean minorValid;
        private float span;
        private float offset;
        private boolean majorValid;
        private View child;
        private boolean childSizeValid;

        public ChildState(View view) {
            this.child = view;
            this.minorValid = false;
            this.majorValid = false;
            this.childSizeValid = false;
            this.child.setParent(AsyncBoxView.this);
        }

        public View getChildView() {
            return this.child;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                AbstractDocument abstractDocument = (AbstractDocument)AsyncBoxView.this.getDocument();
                try {
                    abstractDocument.readLock();
                    if (this.minorValid && this.majorValid && this.childSizeValid) {
                        return;
                    }
                    if (this.child.getParent() != AsyncBoxView.this) break block11;
                    AsyncBoxView asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = this;
                    }
                    this.updateChild();
                    asyncBoxView = AsyncBoxView.this;
                    synchronized (asyncBoxView) {
                        AsyncBoxView.this.changing = null;
                    }
                    this.updateChild();
                }
                finally {
                    abstractDocument.readUnlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateChild() {
            float f;
            boolean bl = false;
            ChildState childState = this;
            synchronized (childState) {
                if (!this.minorValid) {
                    int n = AsyncBoxView.this.getMinorAxis();
                    this.min = this.child.getMinimumSpan(n);
                    this.pref = this.child.getPreferredSpan(n);
                    this.max = this.child.getMaximumSpan(n);
                    this.minorValid = true;
                    bl = true;
                }
            }
            if (bl) {
                AsyncBoxView.this.minorRequirementChange(this);
            }
            boolean bl2 = false;
            float f2 = 0.0f;
            ChildState childState2 = this;
            synchronized (childState2) {
                if (!this.majorValid) {
                    f = this.span;
                    this.span = this.child.getPreferredSpan(AsyncBoxView.this.axis);
                    f2 = this.span - f;
                    this.majorValid = true;
                    bl2 = true;
                }
            }
            if (bl2) {
                AsyncBoxView.this.majorRequirementChange(this, f2);
                AsyncBoxView.this.locator.childChanged(this);
            }
            childState2 = this;
            synchronized (childState2) {
                if (!this.childSizeValid) {
                    float f3;
                    if (AsyncBoxView.this.axis == 0) {
                        f = this.span;
                        f3 = this.getMinorSpan();
                    } else {
                        f = this.getMinorSpan();
                        f3 = this.span;
                    }
                    this.childSizeValid = true;
                    this.child.setSize(f, f3);
                }
            }
        }

        public float getMinorSpan() {
            if (this.max < AsyncBoxView.this.minorSpan) {
                return this.max;
            }
            return Math.max(this.min, AsyncBoxView.this.minorSpan);
        }

        public float getMinorOffset() {
            if (this.max < AsyncBoxView.this.minorSpan) {
                float f = this.child.getAlignment(AsyncBoxView.this.getMinorAxis());
                return (AsyncBoxView.this.minorSpan - this.max) * f;
            }
            return 0.0f;
        }

        public float getMajorSpan() {
            return this.span;
        }

        public float getMajorOffset() {
            return this.offset;
        }

        public void setMajorOffset(float f) {
            this.offset = f;
        }

        public void preferenceChanged(boolean bl, boolean bl2) {
            if (AsyncBoxView.this.axis == 0) {
                if (bl) {
                    this.majorValid = false;
                }
                if (bl2) {
                    this.minorValid = false;
                }
            } else {
                if (bl) {
                    this.minorValid = false;
                }
                if (bl2) {
                    this.majorValid = false;
                }
            }
            this.childSizeValid = false;
        }

        public boolean isLayoutValid() {
            return this.minorValid && this.majorValid && this.childSizeValid;
        }
    }

    public class ChildLocator {
        protected ChildState lastValidOffset;
        protected Rectangle lastAlloc = new Rectangle();
        protected Rectangle childAlloc = new Rectangle();

        public synchronized void childChanged(ChildState childState) {
            if (this.lastValidOffset == null) {
                this.lastValidOffset = childState;
            } else if (childState.getChildView().getStartOffset() < this.lastValidOffset.getChildView().getStartOffset()) {
                this.lastValidOffset = childState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void paintChildren(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            float f = AsyncBoxView.this.axis == 0 ? (float)(rectangle.x - this.lastAlloc.x) : (float)(rectangle.y - this.lastAlloc.y);
            int n = this.getViewIndexAtVisualOffset(f);
            int n2 = AsyncBoxView.this.getViewCount();
            float f2 = AsyncBoxView.this.getChildState(n).getMajorOffset();
            for (int i = n; i < n2; ++i) {
                ChildState childState = AsyncBoxView.this.getChildState(i);
                childState.setMajorOffset(f2);
                Shape shape = this.getChildAllocation(i);
                if (!this.intersectsClip(shape, rectangle)) break;
                ChildState childState2 = childState;
                synchronized (childState2) {
                    View view = childState.getChildView();
                    view.paint(graphics, shape);
                }
                f2 += childState.getMajorSpan();
            }
        }

        public synchronized Shape getChildAllocation(int n, Shape shape) {
            if (shape == null) {
                return null;
            }
            this.setAllocation(shape);
            ChildState childState = AsyncBoxView.this.getChildState(n);
            if (this.lastValidOffset == null) {
                this.lastValidOffset = AsyncBoxView.this.getChildState(0);
            }
            if (childState.getChildView().getStartOffset() > this.lastValidOffset.getChildView().getStartOffset()) {
                this.updateChildOffsetsToIndex(n);
            }
            Shape shape2 = this.getChildAllocation(n);
            return shape2;
        }

        public int getViewIndexAtPoint(float f, float f2, Shape shape) {
            this.setAllocation(shape);
            float f3 = AsyncBoxView.this.axis == 0 ? f - (float)this.lastAlloc.x : f2 - (float)this.lastAlloc.y;
            int n = this.getViewIndexAtVisualOffset(f3);
            return n;
        }

        protected Shape getChildAllocation(int n) {
            ChildState childState = AsyncBoxView.this.getChildState(n);
            if (!childState.isLayoutValid()) {
                childState.run();
            }
            if (AsyncBoxView.this.axis == 0) {
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMajorOffset();
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMinorOffset();
                this.childAlloc.width = (int)childState.getMajorSpan();
                this.childAlloc.height = (int)childState.getMinorSpan();
            } else {
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMajorOffset();
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMinorOffset();
                this.childAlloc.height = (int)childState.getMajorSpan();
                this.childAlloc.width = (int)childState.getMinorSpan();
            }
            this.childAlloc.x += (int)AsyncBoxView.this.getLeftInset();
            this.childAlloc.y += (int)AsyncBoxView.this.getRightInset();
            return this.childAlloc;
        }

        protected void setAllocation(Shape shape) {
            if (shape instanceof Rectangle) {
                this.lastAlloc.setBounds((Rectangle)shape);
            } else {
                this.lastAlloc.setBounds(shape.getBounds());
            }
            AsyncBoxView.this.setSize(this.lastAlloc.width, this.lastAlloc.height);
        }

        protected int getViewIndexAtVisualOffset(float f) {
            int n = AsyncBoxView.this.getViewCount();
            if (n > 0) {
                boolean bl;
                boolean bl2 = bl = this.lastValidOffset != null;
                if (this.lastValidOffset == null) {
                    this.lastValidOffset = AsyncBoxView.this.getChildState(0);
                }
                if (f > AsyncBoxView.this.majorSpan) {
                    if (!bl) {
                        return 0;
                    }
                    int n2 = this.lastValidOffset.getChildView().getStartOffset();
                    int n3 = AsyncBoxView.this.getViewIndex(n2, Position.Bias.Forward);
                    return n3;
                }
                if (f > this.lastValidOffset.getMajorOffset()) {
                    return this.updateChildOffsets(f);
                }
                float f2 = 0.0f;
                for (int i = 0; i < n; ++i) {
                    ChildState childState = AsyncBoxView.this.getChildState(i);
                    float f3 = f2 + childState.getMajorSpan();
                    if (f < f3) {
                        return i;
                    }
                    f2 = f3;
                }
            }
            return n - 1;
        }

        int updateChildOffsets(float f) {
            float f2;
            int n = AsyncBoxView.this.getViewCount();
            int n2 = n - 1;
            int n3 = this.lastValidOffset.getChildView().getStartOffset();
            int n4 = AsyncBoxView.this.getViewIndex(n3, Position.Bias.Forward);
            float f3 = f2 = this.lastValidOffset.getMajorOffset();
            for (int i = n4; i < n; ++i) {
                ChildState childState = AsyncBoxView.this.getChildState(i);
                childState.setMajorOffset(f3);
                f3 += childState.getMajorSpan();
                if (!(f < f3)) continue;
                n2 = i;
                this.lastValidOffset = childState;
                break;
            }
            return n2;
        }

        void updateChildOffsetsToIndex(int n) {
            int n2 = this.lastValidOffset.getChildView().getStartOffset();
            int n3 = AsyncBoxView.this.getViewIndex(n2, Position.Bias.Forward);
            float f = this.lastValidOffset.getMajorOffset();
            for (int i = n3; i <= n; ++i) {
                ChildState childState = AsyncBoxView.this.getChildState(i);
                childState.setMajorOffset(f);
                f += childState.getMajorSpan();
            }
        }

        boolean intersectsClip(Shape shape, Rectangle rectangle) {
            Rectangle rectangle2;
            Rectangle rectangle3 = rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (rectangle2.intersects(rectangle)) {
                return this.lastAlloc.intersects(rectangle2);
            }
            return false;
        }
    }
}

