PImage normal_jiggly, big_jiggly, yellow_jiggly;
PImage current_image;
int counter;

void setup(){ // Happens only once.
 size(800, 980);
 background(255, 255, 255); // r, g, b
 frameRate(60);
 imageMode(CENTER);
 
 // Loading three images.
 normal_jiggly = loadImage("stamp.png");        // 1
 big_jiggly    = loadImage("stamp_blue.png");   // 2
 yellow_jiggly = loadImage("stamp_yellow.png"); // 3
  
 counter = 0;
 current_image = normal_jiggly;
}

void draw(){ // Repeats every frame. (60 fps)
  if(mousePressed){ // Is the mouse button being pressed down?
    make_stroke(); // Runs the instructions at the bottom.
  }
}

void mousePressed(){ 
/*Happens when mouse gets pressed.*/

  stroke(random(200, 255));
  
  switch(counter){
    case 0:
      current_image = normal_jiggly;
    break;
    
    case 1:
      current_image = big_jiggly;
    break;
    
    case 2:
      current_image = yellow_jiggly;
    break;
  }

  counter = counter + 1;
  if(counter > 3){
    counter = 0;
  }
}

void mouseReleased(){ /* Happens when mouse gets released.*/ }

void make_stroke(){
 
  if(counter < 3){
    float d = head();
    translate(mouseX, mouseY);
    rotate(d);
    scale(distance()/10);
    tint(mouseX, mouseY, distance(), random(40, 255));
    image(current_image, 0, 0);
    scale(-distance()/10);
    rotate(-d);
    translate(-mouseX, -mouseY);
  } else {
    strokeWeight(30+ (distance()/10));
    line(pmouseX, pmouseY, mouseX, mouseY);
  }
   
 
}

float distance(){
  PVector mousePos = new PVector(mouseX, mouseY); // Vector / Point / Tuple
  PVector pmousePos = new PVector(pmouseX, pmouseY); 
  return 1 + mousePos.dist(pmousePos);
}

float angle(){
  PVector mousePos = new PVector(mouseX, mouseY); // Vector / Point / Tuple
  PVector pmousePos = new PVector(pmouseX, pmouseY); 
  return degrees(PVector.angleBetween(mousePos, pmousePos));
}

float head(){
    PVector mousePos = new PVector(mouseX, mouseY); // Vector / Point / Tuple
    return degrees(mousePos.heading());
}

/* How to respond to mouse speed.
void make_stroke(){ 
  PVector mousePos = new PVector(mouseX, mouseY); // Vector / Point / Tuple
  PVector pmousePos = new PVector(pmouseX, pmouseY); 
  float distance = mousePos.dist(pmousePos);
  println(distance);
  strokeWeight(distance);
  line(pmouseX, pmouseY, mouseX, mouseY);
}
*/

/* How to respond to mouse position on screen.
void make_stroke(){
  line(pmouseX, pmouseY, mouseX, mouseY);
  float x = mouseX / float(width);
  float y = mouseY / float(height);
  println(x, y);
  stroke(y * 255, 0, 0);
  strokeWeight(x * 10);
}
*/














