PImage stamp, stamp2, stamp3;
PImage current_image;
int current_image_number = 0;

void setup(){ // Happens once when program starts.
  size(550, 980); // 'width' and 'height' is now available.
  background(255);
  stamp  = loadImage("stamp.png");
  stamp2 = loadImage("stamp2.png");
  stamp3 = loadImage("stamp3.png");
  current_image = stamp;
  imageMode(CENTER);
}

void draw(){ // Happens every frame (60 fps).
  if(mousePressed){
    brush();
  }
}

void mousePressed(){
  
  current_image_number = current_image_number + 1;
  if(current_image_number > 2){
    current_image_number = 0;
  }
  
  switch(current_image_number){
     case 0:
       current_image = stamp;
     break;
     
     case 1:
       current_image = stamp2;
     break;
     
     case 2:
       current_image = stamp3;
     break;
  }
  
}

void brush(){

   translate(mouseX, mouseY);   
   
   PVector mousePos  = new PVector(mouseX, mouseY);
   PVector pmousePos = new PVector(pmouseX, pmouseY);
   float speed = mousePos.dist(pmousePos);
   
   scale(speed/2);
   rotate(radians(random(360)));
   tint(random(255), random(255), 0, random(40, 100));
   image(current_image, 0, 0);
   
   translate(-mouseX, -mouseY); 

}

/* Responding to the mouse being pressed and released.
void mousePressed(){ // Runs once when you press down mouse.
  strokeWeight(random(10, 50));
}

void mouseReleased(){ // Runs when mouse is released.
  background(255);
}

void brush(){
  line(pmouseX, pmouseY, mouseX, mouseY);
}
*/

/*
// Getting the speed of the mouse.
void brush(){  
  // Two Vectors
  PVector mousePos  = new PVector(mouseX, mouseY);
  PVector pmousePos = new PVector(pmouseX, pmouseY);
  float speed = mousePos.dist(pmousePos);
  strokeWeight(speed);
  line(pmouseX, pmouseY, mouseX, mouseY);
}
*/

/* // Getting the normalized mouse position
void brush(){
  // Happens when the mouse moves,
  // and the mouse button is held down.
  
  // Normalizing
  float horizontal_position = mouseX / float(width);
  float vertical_position   = mouseY / float(height);
  
  strokeWeight(horizontal_position * random(30, 50));
  stroke(vertical_position * random(255));
  
  line(pmouseX, pmouseY, mouseX, mouseY);
}
*/




