/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.invoke.util.ValueConversions;
import sun.misc.Unsafe;

public abstract class MethodHandle {
    private final MethodType type;
    final LambdaForm form;
    private static final LambdaForm.NamedFunction NF_reinvokerTarget;
    private static final long FORM_OFFSET;

    public MethodType type() {
        return this.type;
    }

    MethodHandle(MethodType methodType, LambdaForm lambdaForm) {
        methodType.getClass();
        lambdaForm.getClass();
        this.type = methodType;
        this.form = lambdaForm;
        lambdaForm.prepare();
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable;

    @PolymorphicSignature
    final native Object invokeBasic(Object ... var1) throws Throwable;

    @PolymorphicSignature
    static native Object linkToVirtual(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToStatic(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToSpecial(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToInterface(Object ... var0) throws Throwable;

    public Object invokeWithArguments(Object ... objectArray) throws Throwable {
        int n = objectArray == null ? 0 : objectArray.length;
        MethodType methodType = this.type();
        if (methodType.parameterCount() != n || this.isVarargsCollector()) {
            return this.asType(MethodType.genericMethodType(n)).invokeWithArguments(objectArray);
        }
        MethodHandle methodHandle = methodType.invokers().varargsInvoker();
        return methodHandle.invokeExact(this, objectArray);
    }

    public Object invokeWithArguments(List<?> list) throws Throwable {
        return this.invokeWithArguments(list.toArray());
    }

    public MethodHandle asType(MethodType methodType) {
        if (!this.type.isConvertibleTo(methodType)) {
            throw new WrongMethodTypeException("cannot convert " + this + " to " + methodType);
        }
        return this.convertArguments(methodType);
    }

    public MethodHandle asSpreader(Class<?> clazz, int n) {
        this.asSpreaderChecks(clazz, n);
        int n2 = this.type.parameterCount() - n;
        return MethodHandleImpl.makeSpreadArguments(this, clazz, n2, n);
    }

    private void asSpreaderChecks(Class<?> clazz, int n) {
        this.spreadArrayChecks(clazz, n);
        int n2 = this.type().parameterCount();
        if (n2 < n || n < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread array length");
        }
        if (clazz != Object[].class && n != 0) {
            boolean bl = false;
            Class<?> clazz2 = clazz.getComponentType();
            for (int i = n2 - n; i < n2; ++i) {
                if (MethodType.canConvert(clazz2, this.type().parameterType(i))) continue;
                bl = true;
                break;
            }
            if (bl) {
                ArrayList arrayList = new ArrayList(this.type().parameterList());
                for (int i = n2 - n; i < n2; ++i) {
                    arrayList.set(i, clazz2);
                }
                this.asType(MethodType.methodType(this.type().returnType(), arrayList));
            }
        }
    }

    private void spreadArrayChecks(Class<?> clazz, int n) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array type", clazz);
        }
        if ((n & 0x7F) != n) {
            if ((n & 0xFF) != n) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal", n);
            }
            assert (n >= 128);
            if (clazz2 == Long.TYPE || clazz2 == Double.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal for long[] or double[]", n);
            }
        }
    }

    public MethodHandle asCollector(Class<?> clazz, int n) {
        this.asCollectorChecks(clazz, n);
        int n2 = this.type().parameterCount() - 1;
        MethodHandle methodHandle = this;
        if (clazz != this.type().parameterType(n2)) {
            methodHandle = this.convertArguments(this.type().changeParameterType(n2, clazz));
        }
        MethodHandle methodHandle2 = ValueConversions.varargsArray(clazz, n);
        return MethodHandles.collectArguments(methodHandle, n2, methodHandle2);
    }

    private boolean asCollectorChecks(Class<?> clazz, int n) {
        this.spreadArrayChecks(clazz, n);
        int n2 = this.type().parameterCount();
        if (n2 != 0) {
            Class<?> clazz2 = this.type().parameterType(n2 - 1);
            if (clazz2 == clazz) {
                return true;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return false;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("array type not assignable to trailing argument", this, clazz);
    }

    public MethodHandle asVarargsCollector(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        boolean bl = this.asCollectorChecks(clazz, 0);
        if (this.isVarargsCollector() && bl) {
            return this;
        }
        return MethodHandleImpl.makeVarargsCollector(this, clazz);
    }

    public boolean isVarargsCollector() {
        return false;
    }

    public MethodHandle asFixedArity() {
        assert (!this.isVarargsCollector());
        return this;
    }

    public MethodHandle bindTo(Object object) {
        Class<?> clazz;
        MethodType methodType = this.type();
        if (methodType.parameterCount() == 0 || (clazz = methodType.parameterType(0)).isPrimitive()) {
            throw MethodHandleStatics.newIllegalArgumentException("no leading reference parameter", object);
        }
        object = clazz.cast(object);
        return this.bindReceiver(object);
    }

    public String toString() {
        if (MethodHandleStatics.DEBUG_METHOD_HANDLE_NAMES) {
            return this.debugString();
        }
        return this.standardString();
    }

    String standardString() {
        return "MethodHandle" + this.type;
    }

    String debugString() {
        return this.standardString() + "/LF=" + this.internalForm() + this.internalProperties();
    }

    MethodHandle setVarargs(MemberName memberName) throws IllegalAccessException {
        Class<?> clazz;
        if (!memberName.isVarargs()) {
            return this;
        }
        int n = this.type().parameterCount();
        if (n != 0 && (clazz = this.type().parameterType(n - 1)).isArray()) {
            return MethodHandleImpl.makeVarargsCollector(this, clazz);
        }
        throw memberName.makeAccessException("cannot make variable arity", null);
    }

    MethodHandle viewAsType(MethodType methodType) {
        if (!this.type.isViewableAs(methodType)) {
            throw new InternalError();
        }
        return MethodHandleImpl.makePairwiseConvert(this, methodType, 0);
    }

    LambdaForm internalForm() {
        return this.form;
    }

    MemberName internalMemberName() {
        return null;
    }

    Object internalValues() {
        return null;
    }

    Object internalProperties() {
        return "";
    }

    MethodHandle convertArguments(MethodType methodType) {
        return MethodHandleImpl.makePairwiseConvert(this, methodType, 1);
    }

    MethodHandle bindArgument(int n, char c, Object object) {
        return this.rebind().bindArgument(n, c, object);
    }

    MethodHandle bindReceiver(Object object) {
        return this.bindArgument(0, 'L', object);
    }

    MethodHandle bindImmediate(int n, char c, Object object) {
        assert (n == 0 && c == 'L' && object instanceof Unsafe);
        MethodType methodType = this.type.dropParameterTypes(n, n + 1);
        LambdaForm lambdaForm = this.form.bindImmediate(n + 1, c, object);
        return this.copyWith(methodType, lambdaForm);
    }

    MethodHandle copyWith(MethodType methodType, LambdaForm lambdaForm) {
        throw new InternalError("copyWith: " + this.getClass());
    }

    MethodHandle dropArguments(MethodType methodType, int n, int n2) {
        return this.rebind().dropArguments(methodType, n, n2);
    }

    MethodHandle permuteArguments(MethodType methodType, int[] nArray) {
        return this.rebind().permuteArguments(methodType, nArray);
    }

    MethodHandle rebind() {
        MethodType methodType = this.type();
        LambdaForm lambdaForm = MethodHandle.reinvokerForm(methodType.basicType());
        return BoundMethodHandle.bindSingle(methodType, lambdaForm, this);
    }

    MethodHandle reinvokerTarget() {
        throw new InternalError("not a reinvoker MH: " + this.getClass().getName() + ": " + this);
    }

    static LambdaForm reinvokerForm(MethodType methodType) {
        int n;
        LambdaForm lambdaForm = (methodType = methodType.basicType()).form().cachedLambdaForm(8);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        MethodHandle methodHandle = MethodHandles.basicInvoker(methodType);
        int n2 = n = 1 + methodType.parameterCount();
        int n3 = n2++;
        int n4 = n2++;
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n2 - n, methodType.invokerType());
        nameArray[n3] = new LambdaForm.Name(NF_reinvokerTarget, nameArray[0]);
        Object[] objectArray = Arrays.copyOfRange(nameArray, 0, n, Object[].class);
        objectArray[0] = nameArray[n3];
        nameArray[n4] = new LambdaForm.Name(methodHandle, objectArray);
        return methodType.form().setCachedLambdaForm(8, new LambdaForm("BMH.reinvoke", n, nameArray));
    }

    void updateForm(LambdaForm lambdaForm) {
        if (this.form == lambdaForm) {
            return;
        }
        MethodHandleStatics.UNSAFE.putObject((Object)this, FORM_OFFSET, (Object)lambdaForm);
        this.form.prepare();
    }

    static {
        MethodHandleImpl.initStatics();
        try {
            NF_reinvokerTarget = new LambdaForm.NamedFunction(MethodHandle.class.getDeclaredMethod("reinvokerTarget", new Class[0]));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
        try {
            FORM_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodHandle.class.getDeclaredField("form"));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

