/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class LocaleObjectCache<K, V> {
    private ConcurrentMap<K, CacheEntry<K, V>> map;
    private ReferenceQueue<V> queue = new ReferenceQueue();

    public LocaleObjectCache() {
        this(16, 0.75f, 16);
    }

    public LocaleObjectCache(int n, float f, int n2) {
        this.map = new ConcurrentHashMap<K, CacheEntry<K, V>>(n, f, n2);
    }

    public V get(K k) {
        V v = null;
        this.cleanStaleEntries();
        CacheEntry<K, V> cacheEntry = (CacheEntry<K, V>)this.map.get(k);
        if (cacheEntry != null) {
            v = (V)cacheEntry.get();
        }
        if (v == null) {
            k = this.normalizeKey(k);
            V v2 = this.createObject(k);
            if (k == null || v2 == null) {
                return null;
            }
            CacheEntry<K, V> cacheEntry2 = new CacheEntry<K, V>(k, v2, this.queue);
            cacheEntry = this.map.putIfAbsent(k, cacheEntry2);
            if (cacheEntry == null) {
                v = v2;
            } else {
                v = (V)cacheEntry.get();
                if (v == null) {
                    this.map.put(k, cacheEntry2);
                    v = v2;
                }
            }
        }
        return v;
    }

    protected V put(K k, V v) {
        CacheEntry<K, V> cacheEntry = new CacheEntry<K, V>(k, v, this.queue);
        CacheEntry<K, V> cacheEntry2 = this.map.put(k, cacheEntry);
        return cacheEntry2 == null ? null : (V)cacheEntry2.get();
    }

    private void cleanStaleEntries() {
        CacheEntry cacheEntry;
        while ((cacheEntry = (CacheEntry)this.queue.poll()) != null) {
            this.map.remove(cacheEntry.getKey());
        }
    }

    protected abstract V createObject(K var1);

    protected K normalizeKey(K k) {
        return k;
    }

    private static class CacheEntry<K, V>
    extends SoftReference<V> {
        private K key;

        CacheEntry(K k, V v, ReferenceQueue<V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
        }

        K getKey() {
            return this.key;
        }
    }
}

