Brush[] brushes = new Brush[1];
Brush selectedBrush;

void setup(){
  brushes = new Brush[] {new MyBrush()};
  selectedBrush = selectBrushByName("MyBrush");
  size(800, 600);
  background(255);
}

void draw(){ selectedBrush.render(); }
void mousePressed(){ selectedBrush.pressed(); }
void mouseReleased(){ selectedBrush.released(); }
void mouseDragged(){ selectedBrush.dragged(); }

Brush selectBrushByName(String name){
  for(Brush b : brushes){
    if(name == b.name()){
      return b;
    }
  }
  return brushes[0];
}



interface Brush {
  public String name();
  public void render();
  public void pressed();
  public void released();
  public void dragged();
}
class MyBrush implements Brush {
 
 // Public variables here.
  
 MyBrush(){
 // Setup
 } 
  
 public String name(){
   return "MyBrush";
 };
 
 public void render(){
   // Your code here.
 } 
 
 public void pressed(){
   // Your code here.
 }

 public void released(){
   // Your code here.
 } 
 
 public void dragged(){
   // Your code here
   ellipse(mouseX, mouseY, 10, 10);
 } 
 
 // insert make_stroke here
 
 
}

