/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class URIQueryProps {
    private static final String QMARK = "?";
    private static final char ASSIG = '=';
    private static final String EMPTY = "";
    private final String query_separator;
    private final HashMap<String, String> properties = new HashMap();

    private URIQueryProps(char c) {
        this.query_separator = String.valueOf(c);
    }

    public final Map<String, String> getProperties() {
        return this.properties;
    }

    public final char getQuerySeparator() {
        return this.query_separator.charAt(0);
    }

    public final String appendQuery(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (null != string) {
            if (!string.startsWith(QMARK)) {
                string = string.substring(1);
            }
            stringBuilder.append(string);
            if (!string.endsWith(this.query_separator)) {
                bl = true;
            }
        }
        Iterator<Map.Entry<String, String>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuilder.append(this.query_separator);
            }
            Map.Entry<String, String> entry = iterator.next();
            stringBuilder.append(entry.getKey());
            if (EMPTY != entry.getValue()) {
                stringBuilder.append('=').append(entry.getValue());
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public final URI appendQuery(URI uRI) throws URISyntaxException {
        return new URI(uRI.getScheme(), uRI.getRawUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getRawPath(), this.appendQuery(uRI.getRawQuery()), uRI.getRawFragment());
    }

    public static final URIQueryProps create(URI uRI, char c) throws IllegalArgumentException {
        if (';' != c && '&' != c) {
            throw new IllegalArgumentException("querySeparator is invalid: " + c);
        }
        URIQueryProps uRIQueryProps = new URIQueryProps(c);
        String string = uRI.getQuery();
        int n = null != string ? string.length() : -1;
        int n2 = -1;
        while (n2 < n) {
            String string2;
            int n3;
            int n4 = n2 + 1;
            if (0 == (n2 = string.indexOf(c, n4))) continue;
            if (0 > n2) {
                n2 = n;
            }
            if (0 < (n3 = (string2 = string.substring(n4, n2)).indexOf(61))) {
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1);
                uRIQueryProps.properties.put(string3, string4);
                continue;
            }
            uRIQueryProps.properties.put(string2, EMPTY);
        }
        return uRIQueryProps;
    }
}

