Brush[] brushes = new Brush[1];
Brush selectedBrush;

void setup(){
  brushes = new Brush[] {new MyBrush()};
  selectedBrush = selectBrushByName("MyBrush");
  size(800, 600);
  background(255);
}

void draw(){ selectedBrush.render(); }
void mousePressed(){ selectedBrush.pressed(); }
void mouseReleased(){ selectedBrush.released(); }
void mouseDragged(){ selectedBrush.dragged(); }

Brush selectBrushByName(String name){
  for(Brush b : brushes){
    if(name == b.name()){
      return b;
    }
  }
  return brushes[0];
}



interface Brush {
  public String name();
  public void render();
  public void pressed();
  public void released();
  public void dragged();
}
class MyBrush implements Brush {
  
 PImage toaststamp;

int original_x = 0;
int original_y = 0;

String current_step = "toast";
 
 MyBrush(){
background(255);
  toaststamp = loadImage("toaststamp.png");
  imageMode(CENTER);

 }
  
 public String name(){
   return "MyBrush";
 };
 
 public void render(){
   
   
 }
 
 public void pressed(){
   if(current_step == "toast"){
    original_x = mouseX;
    original_y = mouseY;
    brush();
 }

 public void released(){
    if(current_step == "toast"){
    current_step = "burn";
  } else if(current_step == "burn") {
    current_step = "toast";
 }
 
 public void dragged(){
   if(current_step == "toast"){
    stroke(214, 177, 27, 25);
    strokeWeight(30);
    line(pmouseX, pmouseY, mouseX, mouseY);
  }
  
  if(current_step == "burn"){
    stroke(255, 255, 255, 50);
    strokeWeight(20);
    fill(255, 255, 255, 50);
    ellipse(mouseX, mouseY, 40, 40);
  }
  
   brush();
 }   

void brush(){
  image(toaststamp, original_x, original_y);
}

